/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.profiling.FrameGroupID;
import org.elasticsearch.xpack.profiling.GetFlamegraphResponse;
import org.elasticsearch.xpack.profiling.GetStackTracesAction;
import org.elasticsearch.xpack.profiling.GetStackTracesRequest;
import org.elasticsearch.xpack.profiling.GetStackTracesResponse;
import org.elasticsearch.xpack.profiling.StackFrame;
import org.elasticsearch.xpack.profiling.StackTrace;
import org.elasticsearch.xpack.profiling.StopWatch;

public class TransportGetFlamegraphAction
extends HandledTransportAction<GetStackTracesRequest, GetFlamegraphResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetFlamegraphAction.class);
    private static final StackFrame EMPTY_STACKFRAME = new StackFrame("", "", 0, 0);
    private final NodeClient nodeClient;
    private final TransportService transportService;

    @Inject
    public TransportGetFlamegraphAction(NodeClient nodeClient, TransportService transportService, ActionFilters actionFilters) {
        super("indices:data/read/profiling/flamegraph", transportService, actionFilters, GetStackTracesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nodeClient = nodeClient;
        this.transportService = transportService;
    }

    protected void doExecute(Task task, GetStackTracesRequest request, final ActionListener<GetFlamegraphResponse> listener) {
        ParentTaskAssigningClient client = new ParentTaskAssigningClient((Client)this.nodeClient, this.transportService.getLocalNode(), task);
        final StopWatch watch = new StopWatch("getFlamegraphAction");
        client.execute((ActionType)GetStackTracesAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<GetStackTracesResponse>(){

            public void onResponse(GetStackTracesResponse response) {
                try {
                    StopWatch processingWatch = new StopWatch("Processing response");
                    GetFlamegraphResponse flamegraphResponse = TransportGetFlamegraphAction.buildFlamegraph(response);
                    log.debug(() -> watch.report() + " " + processingWatch.report());
                    listener.onResponse((Object)flamegraphResponse);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static GetFlamegraphResponse buildFlamegraph(GetStackTracesResponse response) {
        FlamegraphBuilder builder = new FlamegraphBuilder(response.getTotalSamples(), response.getTotalFrames(), response.getSamplingRate());
        if (response.getTotalFrames() == 0) {
            return builder.build();
        }
        TreeMap<String, StackTrace> sortedStacktraces = new TreeMap<String, StackTrace>(response.getStackTraces());
        for (Map.Entry st : sortedStacktraces.entrySet()) {
            StackTrace stackTrace = (StackTrace)st.getValue();
            builder.setCurrentNode(0);
            long samples = stackTrace.count;
            builder.addSamplesInclusive(0, samples);
            builder.addSamplesExclusive(0, 0L);
            double annualCO2Tons = stackTrace.annualCO2Tons;
            builder.addAnnualCO2TonsInclusive(0, annualCO2Tons);
            builder.addAnnualCO2TonsExclusive(0, 0.0);
            double annualCostsUSD = stackTrace.annualCostsUSD;
            builder.addAnnualCostsUSDInclusive(0, annualCostsUSD);
            builder.addAnnualCostsUSDExclusive(0, 0.0);
            int frameCount = stackTrace.frameIds.size();
            for (int i = 0; i < frameCount; ++i) {
                String frameId = stackTrace.frameIds.get(i);
                String fileId = stackTrace.fileIds.get(i);
                Integer frameType = stackTrace.typeIds.get(i);
                Integer addressOrLine = stackTrace.addressOrLines.get(i);
                StackFrame stackFrame = response.getStackFrames().getOrDefault(frameId, EMPTY_STACKFRAME);
                String executable = response.getExecutables().getOrDefault(fileId, "");
                boolean isLeafFrame = i == frameCount - 1;
                stackFrame.forEach(frame -> {
                    int nodeId;
                    String frameGroupId = FrameGroupID.create(fileId, addressOrLine, executable, frame.fileName(), frame.functionName());
                    if (builder.isExists(frameGroupId)) {
                        nodeId = builder.getNodeId(frameGroupId);
                        builder.addSamplesInclusive(nodeId, samples);
                        builder.addAnnualCO2TonsInclusive(nodeId, annualCO2Tons);
                        builder.addAnnualCostsUSDInclusive(nodeId, annualCostsUSD);
                    } else {
                        nodeId = builder.addNode(fileId, frameType, frame.inline(), executable, addressOrLine, frame.functionName(), frame.functionOffset(), frame.fileName(), frame.lineNumber(), samples, annualCO2Tons, annualCostsUSD, frameGroupId);
                    }
                    if (isLeafFrame && frame.last()) {
                        builder.addSamplesExclusive(nodeId, samples);
                        builder.addAnnualCO2TonsExclusive(nodeId, annualCO2Tons);
                        builder.addAnnualCostsUSDExclusive(nodeId, annualCostsUSD);
                    }
                    builder.setCurrentNode(nodeId);
                });
            }
        }
        return builder.build();
    }

    private static class FlamegraphBuilder {
        private int currentNode = 0;
        private int size = 0;
        private long selfCPU;
        private long totalCPU;
        private final long totalSamples;
        private final List<Map<String, Integer>> edges;
        private final List<String> fileIds;
        private final List<Integer> frameTypes;
        private final List<Boolean> inlineFrames;
        private final List<String> fileNames;
        private final List<Integer> addressOrLines;
        private final List<String> functionNames;
        private final List<Integer> functionOffsets;
        private final List<String> sourceFileNames;
        private final List<Integer> sourceLines;
        private final List<Long> countInclusive;
        private final List<Long> countExclusive;
        private final List<Double> annualCO2TonsExclusive;
        private final List<Double> annualCO2TonsInclusive;
        private final List<Double> annualCostsUSDExclusive;
        private final List<Double> annualCostsUSDInclusive;
        private final double samplingRate;

        FlamegraphBuilder(long totalSamples, int frames, double samplingRate) {
            int capacity = (int)((double)frames * 1.1);
            this.edges = new ArrayList<Map<String, Integer>>(capacity);
            this.fileIds = new ArrayList<String>(capacity);
            this.frameTypes = new ArrayList<Integer>(capacity);
            this.inlineFrames = new ArrayList<Boolean>(capacity);
            this.fileNames = new ArrayList<String>(capacity);
            this.addressOrLines = new ArrayList<Integer>(capacity);
            this.functionNames = new ArrayList<String>(capacity);
            this.functionOffsets = new ArrayList<Integer>(capacity);
            this.sourceFileNames = new ArrayList<String>(capacity);
            this.sourceLines = new ArrayList<Integer>(capacity);
            this.countInclusive = new ArrayList<Long>(capacity);
            this.countExclusive = new ArrayList<Long>(capacity);
            this.annualCO2TonsInclusive = new ArrayList<Double>(capacity);
            this.annualCO2TonsExclusive = new ArrayList<Double>(capacity);
            this.annualCostsUSDInclusive = new ArrayList<Double>(capacity);
            this.annualCostsUSDExclusive = new ArrayList<Double>(capacity);
            this.totalSamples = totalSamples;
            int nodeId = this.addNode("", 0, false, "", 0, "", 0, "", 0, 0L, 0.0, 0.0, null);
            this.setCurrentNode(nodeId);
            this.samplingRate = samplingRate;
        }

        public int addNode(String fileId, int frameType, boolean inline, String fileName, Integer addressOrLine, String functionName, int functionOffset, String sourceFileName, int sourceLine, long samples, double annualCO2Tons, double annualCostsUSD, String frameGroupId) {
            int node = this.size;
            this.edges.add(new HashMap());
            this.fileIds.add(fileId);
            this.frameTypes.add(frameType);
            this.inlineFrames.add(inline);
            this.fileNames.add(fileName);
            this.addressOrLines.add(addressOrLine);
            this.functionNames.add(functionName);
            this.functionOffsets.add(functionOffset);
            this.sourceFileNames.add(sourceFileName);
            this.sourceLines.add(sourceLine);
            this.countInclusive.add(samples);
            this.totalCPU += samples;
            this.countExclusive.add(0L);
            this.annualCO2TonsInclusive.add(annualCO2Tons);
            this.annualCO2TonsExclusive.add(0.0);
            this.annualCostsUSDInclusive.add(annualCostsUSD);
            this.annualCostsUSDExclusive.add(0.0);
            if (frameGroupId != null) {
                this.edges.get(this.currentNode).put(frameGroupId, node);
            }
            ++this.size;
            return node;
        }

        public void setCurrentNode(int nodeId) {
            this.currentNode = nodeId;
        }

        public boolean isExists(String frameGroupId) {
            return this.edges.get(this.currentNode).containsKey(frameGroupId);
        }

        public int getNodeId(String frameGroupId) {
            return this.edges.get(this.currentNode).get(frameGroupId);
        }

        public void addSamplesInclusive(int nodeId, long sampleCount) {
            Long priorSampleCount = this.countInclusive.get(nodeId);
            this.countInclusive.set(nodeId, priorSampleCount + sampleCount);
            this.totalCPU += sampleCount;
        }

        public void addSamplesExclusive(int nodeId, long sampleCount) {
            Long priorSampleCount = this.countExclusive.get(nodeId);
            this.countExclusive.set(nodeId, priorSampleCount + sampleCount);
            this.selfCPU += sampleCount;
        }

        public void addAnnualCO2TonsInclusive(int nodeId, double annualCO2Tons) {
            Double priorAnnualCO2Tons = this.annualCO2TonsInclusive.get(nodeId);
            this.annualCO2TonsInclusive.set(nodeId, priorAnnualCO2Tons + annualCO2Tons);
        }

        public void addAnnualCO2TonsExclusive(int nodeId, double annualCO2Tons) {
            Double priorAnnualCO2Tons = this.annualCO2TonsExclusive.get(nodeId);
            this.annualCO2TonsExclusive.set(nodeId, priorAnnualCO2Tons + annualCO2Tons);
        }

        public void addAnnualCostsUSDInclusive(int nodeId, double annualCostsUSD) {
            Double priorAnnualCostsUSD = this.annualCostsUSDInclusive.get(nodeId);
            this.annualCostsUSDInclusive.set(nodeId, priorAnnualCostsUSD + annualCostsUSD);
        }

        public void addAnnualCostsUSDExclusive(int nodeId, double annualCostsUSD) {
            Double priorAnnualCostsUSD = this.annualCostsUSDExclusive.get(nodeId);
            this.annualCostsUSDExclusive.set(nodeId, priorAnnualCostsUSD + annualCostsUSD);
        }

        public GetFlamegraphResponse build() {
            return new GetFlamegraphResponse(this.size, this.samplingRate, this.edges, this.fileIds, this.frameTypes, this.inlineFrames, this.fileNames, this.addressOrLines, this.functionNames, this.functionOffsets, this.sourceFileNames, this.sourceLines, this.countInclusive, this.countExclusive, this.annualCO2TonsInclusive, this.annualCO2TonsExclusive, this.annualCostsUSDInclusive, this.annualCostsUSDExclusive, this.selfCPU, this.totalCPU, this.totalSamples);
        }
    }
}

