/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.profiling.GetFlamegraphAction;
import org.elasticsearch.xpack.profiling.GetStackTracesAction;
import org.elasticsearch.xpack.profiling.GetStatusAction;
import org.elasticsearch.xpack.profiling.IndexStateResolver;
import org.elasticsearch.xpack.profiling.ProfilingDataStreamManager;
import org.elasticsearch.xpack.profiling.ProfilingIndexManager;
import org.elasticsearch.xpack.profiling.ProfilingIndexTemplateRegistry;
import org.elasticsearch.xpack.profiling.ProfilingInfoTransportAction;
import org.elasticsearch.xpack.profiling.ProfilingLicenseChecker;
import org.elasticsearch.xpack.profiling.ProfilingUsageTransportAction;
import org.elasticsearch.xpack.profiling.RestGetFlamegraphAction;
import org.elasticsearch.xpack.profiling.RestGetStackTracesAction;
import org.elasticsearch.xpack.profiling.RestGetStatusAction;
import org.elasticsearch.xpack.profiling.TransportGetFlamegraphAction;
import org.elasticsearch.xpack.profiling.TransportGetStackTracesAction;
import org.elasticsearch.xpack.profiling.TransportGetStatusAction;

public class ProfilingPlugin
extends Plugin
implements ActionPlugin {
    private static final Logger logger = LogManager.getLogger(ProfilingPlugin.class);
    public static final Setting<Boolean> PROFILING_TEMPLATES_ENABLED = Setting.boolSetting((String)"xpack.profiling.templates.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> PROFILING_CHECK_OUTDATED_INDICES = Setting.boolSetting((String)"xpack.profiling.check_outdated_indices", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final String PROFILING_THREAD_POOL_NAME = "profiling";
    private final Settings settings;
    private final boolean enabled;
    private final SetOnce<ProfilingIndexTemplateRegistry> registry = new SetOnce();
    private final SetOnce<ProfilingIndexManager> indexManager = new SetOnce();
    private final SetOnce<ProfilingDataStreamManager> dataStreamManager = new SetOnce();
    private final SetOnce<IndexStateResolver> indexStateResolver = new SetOnce();

    public ProfilingPlugin(Settings settings) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.PROFILING_ENABLED.get(settings);
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        Client client = services.client();
        ClusterService clusterService = services.clusterService();
        ThreadPool threadPool = services.threadPool();
        logger.info("Profiling is {}", (Object)(this.enabled ? "enabled" : "disabled"));
        this.registry.set((Object)new ProfilingIndexTemplateRegistry(this.settings, clusterService, threadPool, client, services.xContentRegistry()));
        this.indexStateResolver.set((Object)new IndexStateResolver((Boolean)PROFILING_CHECK_OUTDATED_INDICES.get(this.settings)));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(PROFILING_CHECK_OUTDATED_INDICES, this::updateCheckOutdatedIndices);
        this.indexManager.set((Object)new ProfilingIndexManager(threadPool, client, clusterService, (IndexStateResolver)this.indexStateResolver.get()));
        this.dataStreamManager.set((Object)new ProfilingDataStreamManager(threadPool, client, clusterService, (IndexStateResolver)this.indexStateResolver.get()));
        this.updateTemplatesEnabled((Boolean)PROFILING_TEMPLATES_ENABLED.get(this.settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(PROFILING_TEMPLATES_ENABLED, this::updateTemplatesEnabled);
        if (this.enabled) {
            ((ProfilingIndexTemplateRegistry)((Object)this.registry.get())).initialize();
            ((ProfilingIndexManager)this.indexManager.get()).initialize();
            ((ProfilingDataStreamManager)this.dataStreamManager.get()).initialize();
        }
        return List.of(this.createLicenseChecker());
    }

    protected ProfilingLicenseChecker createLicenseChecker() {
        return new ProfilingLicenseChecker(XPackPlugin::getSharedLicenseState);
    }

    public void updateCheckOutdatedIndices(boolean newValue) {
        if (!newValue) {
            logger.info("profiling will ignore outdated indices");
        }
        ((IndexStateResolver)this.indexStateResolver.get()).setCheckOutdatedIndices(newValue);
    }

    public void updateTemplatesEnabled(boolean newValue) {
        if (!newValue) {
            logger.info("profiling index templates will not be installed or reinstalled");
        }
        ((ProfilingIndexTemplateRegistry)((Object)this.registry.get())).setTemplatesEnabled(newValue);
        ((ProfilingIndexManager)this.indexManager.get()).setTemplatesEnabled(newValue);
        ((ProfilingDataStreamManager)this.dataStreamManager.get()).setTemplatesEnabled(newValue);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<BaseRestHandler> handlers = new ArrayList<BaseRestHandler>();
        handlers.add(new RestGetStatusAction());
        if (this.enabled) {
            handlers.add(new RestGetStackTracesAction());
            handlers.add(new RestGetFlamegraphAction());
        }
        return Collections.unmodifiableList(handlers);
    }

    public List<Setting<?>> getSettings() {
        return List.of(PROFILING_TEMPLATES_ENABLED, PROFILING_CHECK_OUTDATED_INDICES, TransportGetStackTracesAction.PROFILING_MAX_STACKTRACE_QUERY_SLICES, TransportGetStackTracesAction.PROFILING_MAX_DETAIL_QUERY_SLICES, TransportGetStackTracesAction.PROFILING_QUERY_REALTIME);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return List.of(ProfilingPlugin.responseExecutorBuilder());
    }

    public static ExecutorBuilder<?> responseExecutorBuilder() {
        return new ScalingExecutorBuilder(PROFILING_THREAD_POOL_NAME, 0, 1, TimeValue.timeValueMinutes((long)30L), false);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)GetStackTracesAction.INSTANCE, TransportGetStackTracesAction.class), new ActionPlugin.ActionHandler((ActionType)GetFlamegraphAction.INSTANCE, TransportGetFlamegraphAction.class), new ActionPlugin.ActionHandler((ActionType)GetStatusAction.INSTANCE, TransportGetStatusAction.class), new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.UNIVERSAL_PROFILING, ProfilingUsageTransportAction.class), new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.UNIVERSAL_PROFILING, ProfilingInfoTransportAction.class));
    }

    public void close() {
        ((ProfilingIndexTemplateRegistry)((Object)this.registry.get())).close();
        ((ProfilingIndexManager)this.indexManager.get()).close();
        ((ProfilingDataStreamManager)this.dataStreamManager.get()).close();
    }
}

