/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponse;

public interface TransportResponseHandler<T extends TransportResponse>
extends Writeable.Reader<T> {
    public static final Executor TRANSPORT_WORKER = EsExecutors.DIRECT_EXECUTOR_SERVICE;

    public Executor executor(ThreadPool var1);

    public void handleResponse(T var1);

    public void handleException(TransportException var1);

    public static Empty empty(final Executor executor, final ActionListener<Void> listener) {
        return new Empty(){

            @Override
            public void handleResponse() {
                listener.onResponse(null);
            }

            @Override
            public Executor executor(ThreadPool threadPool) {
                return executor;
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }

            public String toString() {
                return listener.toString();
            }
        };
    }

    public static abstract class Empty
    implements TransportResponseHandler<TransportResponse.Empty> {
        @Override
        public final TransportResponse.Empty read(StreamInput in) {
            return TransportResponse.Empty.INSTANCE;
        }

        @Override
        public final void handleResponse(TransportResponse.Empty ignored) {
            this.handleResponse();
        }

        public abstract void handleResponse();
    }
}

