/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.suggest.Suggest;

public class InternalSearchResponse
extends SearchResponseSections
implements Writeable {
    public static final InternalSearchResponse EMPTY_WITH_TOTAL_HITS = new InternalSearchResponse(SearchHits.EMPTY_WITH_TOTAL_HITS, null, null, null, false, null, 1);
    public static final InternalSearchResponse EMPTY_WITHOUT_TOTAL_HITS = new InternalSearchResponse(SearchHits.EMPTY_WITHOUT_TOTAL_HITS, null, null, null, false, null, 1);

    public InternalSearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, SearchProfileResults profileResults, boolean timedOut, Boolean terminatedEarly, int numReducePhases) {
        super(hits, aggregations, suggest, timedOut, terminatedEarly, profileResults, numReducePhases);
    }

    public InternalSearchResponse(StreamInput in) throws IOException {
        super(new SearchHits(in), in.readBoolean() ? InternalAggregations.readFrom(in) : null, in.readBoolean() ? new Suggest(in) : null, in.readBoolean(), in.readOptionalBoolean(), in.readOptionalWriteable(SearchProfileResults::new), in.readVInt());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.hits.writeTo(out);
        out.writeOptionalWriteable((InternalAggregations)this.aggregations);
        out.writeOptionalWriteable(this.suggest);
        out.writeBoolean(this.timedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileResults);
        out.writeVInt(this.numReducePhases);
    }
}

