/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.StoredValueFetcher;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class TsidExtractingIdFieldMapper
extends IdFieldMapper {
    static final int DESCRIPTION_TSID_LIMIT = 1000;
    public static final TsidExtractingIdFieldMapper INSTANCE = new TsidExtractingIdFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(MappingParserContext::idFieldMapper);
    private static final long SEED = 0L;

    private TsidExtractingIdFieldMapper() {
        super(new IdFieldType());
    }

    public static void createField(DocumentParserContext context, IndexRouting.ExtractFromSource.Builder routingBuilder, BytesRef tsid) {
        List<IndexableField> timestampFields = context.rootDoc().getFields("@timestamp");
        if (timestampFields.isEmpty()) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] is missing");
        }
        long timestamp = timestampFields.get(0).numericValue().longValue();
        byte[] suffix = new byte[16];
        String id = TsidExtractingIdFieldMapper.createId(context.getDynamicMappers().isEmpty(), routingBuilder, tsid, timestamp, suffix);
        IndexRouting.ExtractFromSource indexRouting = (IndexRouting.ExtractFromSource)context.indexSettings().getIndexRouting();
        assert (!context.getDynamicMappers().isEmpty() || !context.getDynamicRuntimeFields().isEmpty() || id.equals(indexRouting.createId(TimeSeriesIdFieldMapper.decodeTsid(tsid), suffix)));
        assert (!context.getDynamicMappers().isEmpty() || !context.getDynamicRuntimeFields().isEmpty() || id.equals(indexRouting.createId(context.sourceToParse().getXContentType(), context.sourceToParse().source(), suffix)));
        if (context.sourceToParse().id() != null && !context.sourceToParse().id().equals(id)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "_id must be unset or set to [%s] but was [%s] because [%s] is in time_series mode", id, context.sourceToParse().id(), context.indexSettings().getIndexMetadata().getIndex().getName()));
        }
        context.id(id);
        BytesRef uidEncoded = Uid.encodeId(context.id());
        context.doc().add((IndexableField)new StringField("_id", uidEncoded, Field.Store.YES));
    }

    public static String createId(boolean dynamicMappersExists, IndexRouting.ExtractFromSource.Builder routingBuilder, BytesRef tsid, long timestamp, byte[] suffix) {
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        MurmurHash3.hash128(tsid.bytes, tsid.offset, tsid.length, 0L, hash);
        ByteUtils.writeLongLE(hash.h1, suffix, 0);
        ByteUtils.writeLongBE(timestamp, suffix, 8);
        String id = routingBuilder.createId(suffix, () -> {
            if (!dynamicMappersExists) {
                throw new IllegalStateException("Didn't find any fields to include in the routing which would be fine if there are dynamic mapping waiting but we couldn't find any of those either!");
            }
            return 0;
        });
        assert (Uid.isURLBase64WithoutPadding(id));
        return id;
    }

    @Override
    public String documentDescription(DocumentParserContext context) {
        IndexableField timestampField;
        StringBuilder description = new StringBuilder("a time series document");
        IndexableField tsidField = context.doc().getField("_tsid");
        if (tsidField != null) {
            description.append(" with dimensions ").append(TsidExtractingIdFieldMapper.tsidDescription(tsidField));
        }
        if ((timestampField = context.doc().getField("@timestamp")) != null) {
            String timestamp = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(timestampField.numericValue().longValue());
            description.append(" at [").append(timestamp).append(']');
        }
        return description.toString();
    }

    @Override
    public String documentDescription(ParsedDocument parsedDocument) {
        IndexableField tsidField = parsedDocument.rootDoc().getField("_tsid");
        long timestamp = parsedDocument.rootDoc().getField("@timestamp").numericValue().longValue();
        String timestampStr = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(timestamp);
        return "[" + parsedDocument.id() + "][" + TsidExtractingIdFieldMapper.tsidDescription(tsidField) + "@" + timestampStr + "]";
    }

    private static String tsidDescription(IndexableField tsidField) {
        String tsid = TimeSeriesIdFieldMapper.decodeTsid(tsidField.binaryValue()).toString();
        if (tsid.length() <= 1000) {
            return tsid;
        }
        return tsid.substring(0, 1000) + "...}";
    }

    @Override
    public String reindexId(String id) {
        return null;
    }

    static final class IdFieldType
    extends TermBasedFieldType {
        IdFieldType() {
            super("_id", true, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_id";
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new StoredValueFetcher(context.lookup(), "_id");
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexed();
            BytesRef[] bytesRefs = (BytesRef[])values.stream().map(v -> {
                Object idObject = v;
                if (idObject instanceof BytesRef) {
                    idObject = ((BytesRef)idObject).utf8ToString();
                }
                return Uid.encodeId(idObject.toString());
            }).toArray(BytesRef[]::new);
            return new TermInSetQuery(this.name(), bytesRefs);
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            return new BlockStoredFieldsReader.IdBlockLoader();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("Fielddata is not supported on [_id] field in [time_series] indices");
        }
    }
}

