/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.ScriptCompiler;

public class MappingParserContext {
    private final Function<String, SimilarityProvider> similarityLookupService;
    private final Function<String, Mapper.TypeParser> typeParsers;
    private final Function<String, RuntimeField.Parser> runtimeFieldParsers;
    private final IndexVersion indexVersionCreated;
    private final Supplier<TransportVersion> clusterTransportVersion;
    private final Supplier<SearchExecutionContext> searchExecutionContextSupplier;
    private final ScriptCompiler scriptCompiler;
    private final IndexAnalyzers indexAnalyzers;
    private final IndexSettings indexSettings;
    private final IdFieldMapper idFieldMapper;
    private final long mappingObjectDepthLimit;
    private long mappingObjectDepth = 0L;

    public MappingParserContext(Function<String, SimilarityProvider> similarityLookupService, Function<String, Mapper.TypeParser> typeParsers, Function<String, RuntimeField.Parser> runtimeFieldParsers, IndexVersion indexVersionCreated, Supplier<TransportVersion> clusterTransportVersion, Supplier<SearchExecutionContext> searchExecutionContextSupplier, ScriptCompiler scriptCompiler, IndexAnalyzers indexAnalyzers, IndexSettings indexSettings, IdFieldMapper idFieldMapper) {
        this.similarityLookupService = similarityLookupService;
        this.typeParsers = typeParsers;
        this.runtimeFieldParsers = runtimeFieldParsers;
        this.indexVersionCreated = indexVersionCreated;
        this.clusterTransportVersion = clusterTransportVersion;
        this.searchExecutionContextSupplier = searchExecutionContextSupplier;
        this.scriptCompiler = scriptCompiler;
        this.indexAnalyzers = indexAnalyzers;
        this.indexSettings = indexSettings;
        this.idFieldMapper = idFieldMapper;
        this.mappingObjectDepthLimit = indexSettings.getMappingDepthLimit();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public IdFieldMapper idFieldMapper() {
        return this.idFieldMapper;
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public SimilarityProvider getSimilarity(String name) {
        return this.similarityLookupService.apply(name);
    }

    public Mapper.TypeParser typeParser(String type) {
        return this.typeParsers.apply(type);
    }

    public RuntimeField.Parser runtimeFieldParser(String type) {
        return this.runtimeFieldParsers.apply(type);
    }

    public IndexVersion indexVersionCreated() {
        return this.indexVersionCreated;
    }

    public Supplier<TransportVersion> clusterTransportVersion() {
        return this.clusterTransportVersion;
    }

    public Supplier<SearchExecutionContext> searchExecutionContext() {
        return this.searchExecutionContextSupplier;
    }

    public DateFormatter getDateFormatter() {
        return null;
    }

    public boolean isWithinMultiField() {
        return false;
    }

    public boolean isFromDynamicTemplate() {
        return false;
    }

    public ScriptCompiler scriptCompiler() {
        return this.scriptCompiler;
    }

    void incrementMappingObjectDepth() throws MapperParsingException {
        ++this.mappingObjectDepth;
        if (this.mappingObjectDepth > this.mappingObjectDepthLimit) {
            throw new MapperParsingException("Limit of mapping depth [" + this.mappingObjectDepthLimit + "] has been exceeded");
        }
    }

    void decrementMappingObjectDepth() throws MapperParsingException {
        --this.mappingObjectDepth;
    }

    public MappingParserContext createMultiFieldContext() {
        return new MultiFieldParserContext(this);
    }

    public MappingParserContext createDynamicTemplateContext(DateFormatter dateFormatter) {
        return new DynamicTemplateParserContext(this, dateFormatter);
    }

    private static class MultiFieldParserContext
    extends MappingParserContext {
        MultiFieldParserContext(MappingParserContext in) {
            super(in.similarityLookupService, in.typeParsers, in.runtimeFieldParsers, in.indexVersionCreated, in.clusterTransportVersion, in.searchExecutionContextSupplier, in.scriptCompiler, in.indexAnalyzers, in.indexSettings, in.idFieldMapper);
        }

        @Override
        public boolean isWithinMultiField() {
            return true;
        }
    }

    private static class DynamicTemplateParserContext
    extends MappingParserContext {
        private final DateFormatter dateFormatter;

        DynamicTemplateParserContext(MappingParserContext in, DateFormatter dateFormatter) {
            super(in.similarityLookupService, in.typeParsers, in.runtimeFieldParsers, in.indexVersionCreated, in.clusterTransportVersion, in.searchExecutionContextSupplier, in.scriptCompiler, in.indexAnalyzers, in.indexSettings, in.idFieldMapper);
            this.dateFormatter = dateFormatter;
        }

        @Override
        public DateFormatter getDateFormatter() {
            return this.dateFormatter;
        }

        @Override
        public boolean isFromDynamicTemplate() {
            return true;
        }
    }
}

