/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface IdLoader {
    public static IdLoader fromLeafStoredFieldLoader() {
        return new StoredIdLoader();
    }

    public static IdLoader createTsIdLoader(IndexRouting.ExtractFromSource indexRouting, List<String> routingPaths) {
        return new TsIdLoader(indexRouting, routingPaths);
    }

    public Leaf leaf(LeafStoredFieldLoader var1, LeafReader var2, int[] var3) throws IOException;

    public static final class StoredIdLoader
    implements IdLoader {
        @Override
        public Leaf leaf(LeafStoredFieldLoader loader, LeafReader reader, int[] docIdsInLeaf) throws IOException {
            return new StoredLeaf(loader);
        }
    }

    public static final class TsIdLoader
    implements IdLoader {
        private final IndexRouting.ExtractFromSource indexRouting;
        private final List<String> routingPaths;

        TsIdLoader(IndexRouting.ExtractFromSource indexRouting, List<String> routingPaths) {
            this.routingPaths = routingPaths;
            this.indexRouting = indexRouting;
        }

        @Override
        public Leaf leaf(LeafStoredFieldLoader loader, LeafReader reader, int[] docIdsInLeaf) throws IOException {
            int docId;
            int i;
            IndexRouting.ExtractFromSource.Builder[] builders = new IndexRouting.ExtractFromSource.Builder[docIdsInLeaf.length];
            for (int i2 = 0; i2 < builders.length; ++i2) {
                builders[i2] = this.indexRouting.builder();
            }
            for (String routingField : this.routingPaths) {
                SortedSetDocValues dv = DocValues.getSortedSet((LeafReader)reader, (String)routingField);
                for (i = 0; i < docIdsInLeaf.length; ++i) {
                    docId = docIdsInLeaf[i];
                    IndexRouting.ExtractFromSource.Builder builder = builders[i];
                    if (!dv.advanceExact(docId)) continue;
                    for (int j = 0; j < dv.docValueCount(); ++j) {
                        BytesRef routingValue = dv.lookupOrd(dv.nextOrd());
                        builder.addMatching(routingField, routingValue);
                    }
                }
            }
            String[] ids = new String[docIdsInLeaf.length];
            SortedDocValues tsIdDocValues = DocValues.getSorted((LeafReader)reader, (String)"_tsid");
            SortedNumericDocValues timestampDocValues = DocValues.getSortedNumeric((LeafReader)reader, (String)"@timestamp");
            for (i = 0; i < docIdsInLeaf.length; ++i) {
                docId = docIdsInLeaf[i];
                boolean found = tsIdDocValues.advanceExact(docId);
                assert (found);
                BytesRef tsid = tsIdDocValues.lookupOrd(tsIdDocValues.ordValue());
                found = timestampDocValues.advanceExact(docId);
                assert (found);
                assert (timestampDocValues.docValueCount() == 1);
                long timestamp = timestampDocValues.nextValue();
                IndexRouting.ExtractFromSource.Builder routingBuilder = builders[i];
                ids[i] = TsidExtractingIdFieldMapper.createId(false, routingBuilder, tsid, timestamp, new byte[16]);
            }
            return new TsIdLeaf(docIdsInLeaf, ids);
        }
    }

    public static final class StoredLeaf
    implements Leaf {
        private final LeafStoredFieldLoader loader;

        StoredLeaf(LeafStoredFieldLoader loader) {
            this.loader = loader;
        }

        @Override
        public String getId(int subDocId) {
            return this.loader.id();
        }
    }

    public static final class TsIdLeaf
    implements Leaf {
        private final String[] ids;
        private final int[] docIdsInLeaf;
        private int idx = -1;

        TsIdLeaf(int[] docIdsInLeaf, String[] ids) {
            this.ids = ids;
            this.docIdsInLeaf = docIdsInLeaf;
        }

        @Override
        public String getId(int subDocId) {
            ++this.idx;
            if (this.docIdsInLeaf[this.idx] != subDocId) {
                throw new IllegalArgumentException("expected to be called with [" + this.docIdsInLeaf[this.idx] + "] but was called with " + subDocId + " instead");
            }
            return this.ids[this.idx];
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Leaf {
        public String getId(int var1);
    }
}

