/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.lookup.Source;

public class BlockLoaderStoredFieldsFromLeafLoader
implements BlockLoader.StoredFields {
    private final LeafStoredFieldLoader loader;
    private final SourceLoader.Leaf sourceLoader;
    private Source source;

    public BlockLoaderStoredFieldsFromLeafLoader(LeafStoredFieldLoader loader, SourceLoader.Leaf sourceLoader) {
        this.loader = loader;
        this.sourceLoader = sourceLoader;
    }

    public void advanceTo(int doc) throws IOException {
        this.loader.advanceTo(doc);
        if (this.sourceLoader != null) {
            this.source = this.sourceLoader.source(this.loader, doc);
        }
    }

    @Override
    public Source source() {
        return this.source;
    }

    @Override
    public String id() {
        return this.loader.id();
    }

    @Override
    public String routing() {
        return this.loader.routing();
    }

    @Override
    public Map<String, List<Object>> storedFields() {
        return this.loader.storedFields();
    }
}

