/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postings;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;

final class ForUtil {
    static final int BLOCK_SIZE = 128;
    private static final int BLOCK_SIZE_LOG2 = 7;
    private final long[] tmp = new long[64];
    private static final long[] MASKS8;
    private static final long[] MASKS16;
    private static final long[] MASKS32;
    private static final long MASK8_1;
    private static final long MASK8_2;
    private static final long MASK8_3;
    private static final long MASK8_4;
    private static final long MASK8_5;
    private static final long MASK8_6;
    private static final long MASK8_7;
    private static final long MASK16_1;
    private static final long MASK16_2;
    private static final long MASK16_3;
    private static final long MASK16_4;
    private static final long MASK16_5;
    private static final long MASK16_6;
    private static final long MASK16_7;
    private static final long MASK16_9;
    private static final long MASK16_10;
    private static final long MASK16_11;
    private static final long MASK16_12;
    private static final long MASK16_13;
    private static final long MASK16_14;
    private static final long MASK16_15;
    private static final long MASK32_1;
    private static final long MASK32_2;
    private static final long MASK32_3;
    private static final long MASK32_4;
    private static final long MASK32_5;
    private static final long MASK32_6;
    private static final long MASK32_7;
    private static final long MASK32_8;
    private static final long MASK32_9;
    private static final long MASK32_10;
    private static final long MASK32_11;
    private static final long MASK32_12;
    private static final long MASK32_13;
    private static final long MASK32_14;
    private static final long MASK32_15;
    private static final long MASK32_17;
    private static final long MASK32_18;
    private static final long MASK32_19;
    private static final long MASK32_20;
    private static final long MASK32_21;
    private static final long MASK32_22;
    private static final long MASK32_23;
    private static final long MASK32_24;

    ForUtil() {
    }

    private static long expandMask32(long mask32) {
        return mask32 | mask32 << 32;
    }

    private static long expandMask16(long mask16) {
        return ForUtil.expandMask32(mask16 | mask16 << 16);
    }

    private static long expandMask8(long mask8) {
        return ForUtil.expandMask16(mask8 | mask8 << 8);
    }

    private static long mask32(int bitsPerValue) {
        return ForUtil.expandMask32((1L << bitsPerValue) - 1L);
    }

    private static long mask16(int bitsPerValue) {
        return ForUtil.expandMask16((1L << bitsPerValue) - 1L);
    }

    private static long mask8(int bitsPerValue) {
        return ForUtil.expandMask8((1L << bitsPerValue) - 1L);
    }

    private static void expand8(long[] arr) {
        for (int i = 0; i < 16; ++i) {
            long l = arr[i];
            arr[i] = l >>> 56 & 0xFFL;
            arr[16 + i] = l >>> 48 & 0xFFL;
            arr[32 + i] = l >>> 40 & 0xFFL;
            arr[48 + i] = l >>> 32 & 0xFFL;
            arr[64 + i] = l >>> 24 & 0xFFL;
            arr[80 + i] = l >>> 16 & 0xFFL;
            arr[96 + i] = l >>> 8 & 0xFFL;
            arr[112 + i] = l & 0xFFL;
        }
    }

    private static void expand8To32(long[] arr) {
        for (int i = 0; i < 16; ++i) {
            long l = arr[i];
            arr[i] = l >>> 24 & 0xFF000000FFL;
            arr[16 + i] = l >>> 16 & 0xFF000000FFL;
            arr[32 + i] = l >>> 8 & 0xFF000000FFL;
            arr[48 + i] = l & 0xFF000000FFL;
        }
    }

    private static void collapse8(long[] arr) {
        for (int i = 0; i < 16; ++i) {
            arr[i] = arr[i] << 56 | arr[16 + i] << 48 | arr[32 + i] << 40 | arr[48 + i] << 32 | arr[64 + i] << 24 | arr[80 + i] << 16 | arr[96 + i] << 8 | arr[112 + i];
        }
    }

    private static void expand16(long[] arr) {
        for (int i = 0; i < 32; ++i) {
            long l = arr[i];
            arr[i] = l >>> 48 & 0xFFFFL;
            arr[32 + i] = l >>> 32 & 0xFFFFL;
            arr[64 + i] = l >>> 16 & 0xFFFFL;
            arr[96 + i] = l & 0xFFFFL;
        }
    }

    private static void expand16To32(long[] arr) {
        for (int i = 0; i < 32; ++i) {
            long l = arr[i];
            arr[i] = l >>> 16 & 0xFFFF0000FFFFL;
            arr[32 + i] = l & 0xFFFF0000FFFFL;
        }
    }

    private static void collapse16(long[] arr) {
        for (int i = 0; i < 32; ++i) {
            arr[i] = arr[i] << 48 | arr[32 + i] << 32 | arr[64 + i] << 16 | arr[96 + i];
        }
    }

    private static void expand32(long[] arr) {
        for (int i = 0; i < 64; ++i) {
            long l = arr[i];
            arr[i] = l >>> 32;
            arr[64 + i] = l & 0xFFFFFFFFL;
        }
    }

    private static void collapse32(long[] arr) {
        for (int i = 0; i < 64; ++i) {
            arr[i] = arr[i] << 32 | arr[64 + i];
        }
    }

    void encode(long[] longs, int bitsPerValue, DataOutput out) throws IOException {
        int i;
        int numLongs;
        int nextPrimitive;
        if (bitsPerValue <= 8) {
            nextPrimitive = 8;
            numLongs = 16;
            ForUtil.collapse8(longs);
        } else if (bitsPerValue <= 16) {
            nextPrimitive = 16;
            numLongs = 32;
            ForUtil.collapse16(longs);
        } else {
            nextPrimitive = 32;
            numLongs = 64;
            ForUtil.collapse32(longs);
        }
        int numLongsPerShift = bitsPerValue * 2;
        int idx = 0;
        int shift = nextPrimitive - bitsPerValue;
        for (i = 0; i < numLongsPerShift; ++i) {
            this.tmp[i] = longs[idx++] << shift;
        }
        shift -= bitsPerValue;
        while (shift >= 0) {
            i = 0;
            while (i < numLongsPerShift) {
                int n = i++;
                this.tmp[n] = this.tmp[n] | longs[idx++] << shift;
            }
            shift -= bitsPerValue;
        }
        int remainingBitsPerLong = shift + bitsPerValue;
        long maskRemainingBitsPerLong = nextPrimitive == 8 ? MASKS8[remainingBitsPerLong] : (nextPrimitive == 16 ? MASKS16[remainingBitsPerLong] : MASKS32[remainingBitsPerLong]);
        int tmpIdx = 0;
        int remainingBitsPerValue = bitsPerValue;
        while (idx < numLongs) {
            long mask2;
            long mask1;
            if (remainingBitsPerValue >= remainingBitsPerLong) {
                int n = tmpIdx++;
                this.tmp[n] = this.tmp[n] | longs[idx] >>> (remainingBitsPerValue -= remainingBitsPerLong) & maskRemainingBitsPerLong;
                if (remainingBitsPerValue != 0) continue;
                ++idx;
                remainingBitsPerValue = bitsPerValue;
                continue;
            }
            if (nextPrimitive == 8) {
                mask1 = MASKS8[remainingBitsPerValue];
                mask2 = MASKS8[remainingBitsPerLong - remainingBitsPerValue];
            } else if (nextPrimitive == 16) {
                mask1 = MASKS16[remainingBitsPerValue];
                mask2 = MASKS16[remainingBitsPerLong - remainingBitsPerValue];
            } else {
                mask1 = MASKS32[remainingBitsPerValue];
                mask2 = MASKS32[remainingBitsPerLong - remainingBitsPerValue];
            }
            int n = tmpIdx;
            this.tmp[n] = this.tmp[n] | (longs[idx++] & mask1) << remainingBitsPerLong - remainingBitsPerValue;
            remainingBitsPerValue = bitsPerValue - remainingBitsPerLong + remainingBitsPerValue;
            int n2 = tmpIdx++;
            this.tmp[n2] = this.tmp[n2] | longs[idx] >>> remainingBitsPerValue & mask2;
        }
        for (int i2 = 0; i2 < numLongsPerShift; ++i2) {
            out.writeLong(this.tmp[i2]);
        }
    }

    int numBytes(int bitsPerValue) {
        return bitsPerValue << 4;
    }

    private static void decodeSlow(int bitsPerValue, DataInput in, long[] tmp, long[] longs) throws IOException {
        int shift;
        int numLongs = bitsPerValue << 1;
        in.readLongs(tmp, 0, numLongs);
        long mask = MASKS32[bitsPerValue];
        int longsIdx = 0;
        for (shift = 32 - bitsPerValue; shift >= 0; shift -= bitsPerValue) {
            ForUtil.shiftLongs(tmp, numLongs, longs, longsIdx, shift, mask);
            longsIdx += numLongs;
        }
        int remainingBitsPerLong = shift + bitsPerValue;
        long mask32RemainingBitsPerLong = MASKS32[remainingBitsPerLong];
        int tmpIdx = 0;
        int remainingBits = remainingBitsPerLong;
        while (longsIdx < 64) {
            int b = bitsPerValue - remainingBits;
            long l = (tmp[tmpIdx++] & MASKS32[remainingBits]) << b;
            while (b >= remainingBitsPerLong) {
                l |= (tmp[tmpIdx++] & mask32RemainingBitsPerLong) << (b -= remainingBitsPerLong);
            }
            if (b > 0) {
                l |= tmp[tmpIdx] >>> remainingBitsPerLong - b & MASKS32[b];
                remainingBits = remainingBitsPerLong - b;
            } else {
                remainingBits = remainingBitsPerLong;
            }
            longs[longsIdx] = l;
            ++longsIdx;
        }
    }

    private static void shiftLongs(long[] a, int count, long[] b, int bi, int shift, long mask) {
        for (int i = 0; i < count; ++i) {
            b[bi + i] = a[i] >>> shift & mask;
        }
    }

    void decode(int bitsPerValue, DataInput in, long[] longs) throws IOException {
        switch (bitsPerValue) {
            case 1: {
                ForUtil.decode1(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 2: {
                ForUtil.decode2(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 3: {
                ForUtil.decode3(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 4: {
                ForUtil.decode4(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 5: {
                ForUtil.decode5(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 6: {
                ForUtil.decode6(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 7: {
                ForUtil.decode7(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 8: {
                ForUtil.decode8(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 9: {
                ForUtil.decode9(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 10: {
                ForUtil.decode10(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 11: {
                ForUtil.decode11(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 12: {
                ForUtil.decode12(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 13: {
                ForUtil.decode13(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 14: {
                ForUtil.decode14(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 15: {
                ForUtil.decode15(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 16: {
                ForUtil.decode16(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 17: {
                ForUtil.decode17(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 18: {
                ForUtil.decode18(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 19: {
                ForUtil.decode19(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 20: {
                ForUtil.decode20(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 21: {
                ForUtil.decode21(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 22: {
                ForUtil.decode22(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 23: {
                ForUtil.decode23(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 24: {
                ForUtil.decode24(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            default: {
                ForUtil.decodeSlow(bitsPerValue, in, this.tmp, longs);
                ForUtil.expand32(longs);
            }
        }
    }

    void decodeTo32(int bitsPerValue, DataInput in, long[] longs) throws IOException {
        switch (bitsPerValue) {
            case 1: {
                ForUtil.decode1(in, this.tmp, longs);
                ForUtil.expand8To32(longs);
                break;
            }
            case 2: {
                ForUtil.decode2(in, this.tmp, longs);
                ForUtil.expand8To32(longs);
                break;
            }
            case 3: {
                ForUtil.decode3(in, this.tmp, longs);
                ForUtil.expand8To32(longs);
                break;
            }
            case 4: {
                ForUtil.decode4(in, this.tmp, longs);
                ForUtil.expand8To32(longs);
                break;
            }
            case 5: {
                ForUtil.decode5(in, this.tmp, longs);
                ForUtil.expand8To32(longs);
                break;
            }
            case 6: {
                ForUtil.decode6(in, this.tmp, longs);
                ForUtil.expand8To32(longs);
                break;
            }
            case 7: {
                ForUtil.decode7(in, this.tmp, longs);
                ForUtil.expand8To32(longs);
                break;
            }
            case 8: {
                ForUtil.decode8(in, this.tmp, longs);
                ForUtil.expand8To32(longs);
                break;
            }
            case 9: {
                ForUtil.decode9(in, this.tmp, longs);
                ForUtil.expand16To32(longs);
                break;
            }
            case 10: {
                ForUtil.decode10(in, this.tmp, longs);
                ForUtil.expand16To32(longs);
                break;
            }
            case 11: {
                ForUtil.decode11(in, this.tmp, longs);
                ForUtil.expand16To32(longs);
                break;
            }
            case 12: {
                ForUtil.decode12(in, this.tmp, longs);
                ForUtil.expand16To32(longs);
                break;
            }
            case 13: {
                ForUtil.decode13(in, this.tmp, longs);
                ForUtil.expand16To32(longs);
                break;
            }
            case 14: {
                ForUtil.decode14(in, this.tmp, longs);
                ForUtil.expand16To32(longs);
                break;
            }
            case 15: {
                ForUtil.decode15(in, this.tmp, longs);
                ForUtil.expand16To32(longs);
                break;
            }
            case 16: {
                ForUtil.decode16(in, this.tmp, longs);
                ForUtil.expand16To32(longs);
                break;
            }
            case 17: {
                ForUtil.decode17(in, this.tmp, longs);
                break;
            }
            case 18: {
                ForUtil.decode18(in, this.tmp, longs);
                break;
            }
            case 19: {
                ForUtil.decode19(in, this.tmp, longs);
                break;
            }
            case 20: {
                ForUtil.decode20(in, this.tmp, longs);
                break;
            }
            case 21: {
                ForUtil.decode21(in, this.tmp, longs);
                break;
            }
            case 22: {
                ForUtil.decode22(in, this.tmp, longs);
                break;
            }
            case 23: {
                ForUtil.decode23(in, this.tmp, longs);
                break;
            }
            case 24: {
                ForUtil.decode24(in, this.tmp, longs);
                break;
            }
            default: {
                ForUtil.decodeSlow(bitsPerValue, in, this.tmp, longs);
            }
        }
    }

    private static void decode1(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 2);
        ForUtil.shiftLongs(tmp, 2, longs, 0, 7, MASK8_1);
        ForUtil.shiftLongs(tmp, 2, longs, 2, 6, MASK8_1);
        ForUtil.shiftLongs(tmp, 2, longs, 4, 5, MASK8_1);
        ForUtil.shiftLongs(tmp, 2, longs, 6, 4, MASK8_1);
        ForUtil.shiftLongs(tmp, 2, longs, 8, 3, MASK8_1);
        ForUtil.shiftLongs(tmp, 2, longs, 10, 2, MASK8_1);
        ForUtil.shiftLongs(tmp, 2, longs, 12, 1, MASK8_1);
        ForUtil.shiftLongs(tmp, 2, longs, 14, 0, MASK8_1);
    }

    private static void decode2(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 4);
        ForUtil.shiftLongs(tmp, 4, longs, 0, 6, MASK8_2);
        ForUtil.shiftLongs(tmp, 4, longs, 4, 4, MASK8_2);
        ForUtil.shiftLongs(tmp, 4, longs, 8, 2, MASK8_2);
        ForUtil.shiftLongs(tmp, 4, longs, 12, 0, MASK8_2);
    }

    private static void decode3(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 6);
        ForUtil.shiftLongs(tmp, 6, longs, 0, 5, MASK8_3);
        ForUtil.shiftLongs(tmp, 6, longs, 6, 2, MASK8_3);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 12;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK8_2) << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & MASK8_1;
            long l1 = (tmp[tmpIdx + 1] & MASK8_1) << 2;
            longs[longsIdx + 1] = l1 |= (tmp[tmpIdx + 2] & MASK8_2) << 0;
            ++iter;
            tmpIdx += 3;
            longsIdx += 2;
        }
    }

    private static void decode4(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 8);
        ForUtil.shiftLongs(tmp, 8, longs, 0, 4, MASK8_4);
        ForUtil.shiftLongs(tmp, 8, longs, 8, 0, MASK8_4);
    }

    private static void decode5(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 10);
        ForUtil.shiftLongs(tmp, 10, longs, 0, 3, MASK8_5);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 10;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK8_3) << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & MASK8_2;
            long l1 = (tmp[tmpIdx + 1] & MASK8_1) << 4;
            l1 |= (tmp[tmpIdx + 2] & MASK8_3) << 1;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 2 & MASK8_1;
            long l2 = (tmp[tmpIdx + 3] & MASK8_2) << 3;
            longs[longsIdx + 2] = l2 |= (tmp[tmpIdx + 4] & MASK8_3) << 0;
            ++iter;
            tmpIdx += 5;
            longsIdx += 3;
        }
    }

    private static void decode6(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 12);
        ForUtil.shiftLongs(tmp, 12, longs, 0, 2, MASK8_6);
        ForUtil.shiftLongs(tmp, 12, tmp, 0, 0, MASK8_2);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 12;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 4;
            l0 |= tmp[tmpIdx + 1] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            ++longsIdx;
        }
    }

    private static void decode7(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 14);
        ForUtil.shiftLongs(tmp, 14, longs, 0, 1, MASK8_7);
        ForUtil.shiftLongs(tmp, 14, tmp, 0, 0, MASK8_1);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 14;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 6;
            l0 |= tmp[tmpIdx + 1] << 5;
            l0 |= tmp[tmpIdx + 2] << 4;
            l0 |= tmp[tmpIdx + 3] << 3;
            l0 |= tmp[tmpIdx + 4] << 2;
            l0 |= tmp[tmpIdx + 5] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            ++longsIdx;
        }
    }

    private static void decode8(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(longs, 0, 16);
    }

    private static void decode9(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 18);
        ForUtil.shiftLongs(tmp, 18, longs, 0, 7, MASK16_9);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 18;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK16_7) << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 5 & MASK16_2;
            long l1 = (tmp[tmpIdx + 1] & MASK16_5) << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 3 & MASK16_4;
            long l2 = (tmp[tmpIdx + 2] & MASK16_3) << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 1 & MASK16_6;
            long l3 = (tmp[tmpIdx + 3] & MASK16_1) << 8;
            l3 |= (tmp[tmpIdx + 4] & MASK16_7) << 1;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 5] >>> 6 & MASK16_1;
            long l4 = (tmp[tmpIdx + 5] & MASK16_6) << 3;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 6] >>> 4 & MASK16_3;
            long l5 = (tmp[tmpIdx + 6] & MASK16_4) << 5;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 7] >>> 2 & MASK16_5;
            long l6 = (tmp[tmpIdx + 7] & MASK16_2) << 7;
            longs[longsIdx + 6] = l6 |= (tmp[tmpIdx + 8] & MASK16_7) << 0;
            ++iter;
            tmpIdx += 9;
            longsIdx += 7;
        }
    }

    private static void decode10(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 20);
        ForUtil.shiftLongs(tmp, 20, longs, 0, 6, MASK16_10);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 20;
        while (iter < 4) {
            long l0 = (tmp[tmpIdx + 0] & MASK16_6) << 4;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 2 & MASK16_4;
            long l1 = (tmp[tmpIdx + 1] & MASK16_2) << 8;
            l1 |= (tmp[tmpIdx + 2] & MASK16_6) << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 4 & MASK16_2;
            long l2 = (tmp[tmpIdx + 3] & MASK16_4) << 6;
            longs[longsIdx + 2] = l2 |= (tmp[tmpIdx + 4] & MASK16_6) << 0;
            ++iter;
            tmpIdx += 5;
            longsIdx += 3;
        }
    }

    private static void decode11(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 22);
        ForUtil.shiftLongs(tmp, 22, longs, 0, 5, MASK16_11);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 22;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK16_5) << 6;
            l0 |= (tmp[tmpIdx + 1] & MASK16_5) << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 4 & MASK16_1;
            long l1 = (tmp[tmpIdx + 2] & MASK16_4) << 7;
            l1 |= (tmp[tmpIdx + 3] & MASK16_5) << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 3 & MASK16_2;
            long l2 = (tmp[tmpIdx + 4] & MASK16_3) << 8;
            l2 |= (tmp[tmpIdx + 5] & MASK16_5) << 3;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 2 & MASK16_3;
            long l3 = (tmp[tmpIdx + 6] & MASK16_2) << 9;
            l3 |= (tmp[tmpIdx + 7] & MASK16_5) << 4;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 1 & MASK16_4;
            long l4 = (tmp[tmpIdx + 8] & MASK16_1) << 10;
            l4 |= (tmp[tmpIdx + 9] & MASK16_5) << 5;
            longs[longsIdx + 4] = l4 |= (tmp[tmpIdx + 10] & MASK16_5) << 0;
            ++iter;
            tmpIdx += 11;
            longsIdx += 5;
        }
    }

    private static void decode12(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 24);
        ForUtil.shiftLongs(tmp, 24, longs, 0, 4, MASK16_12);
        ForUtil.shiftLongs(tmp, 24, tmp, 0, 0, MASK16_4);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 24;
        while (iter < 8) {
            long l0 = tmp[tmpIdx + 0] << 8;
            l0 |= tmp[tmpIdx + 1] << 4;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            ++longsIdx;
        }
    }

    private static void decode13(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 26);
        ForUtil.shiftLongs(tmp, 26, longs, 0, 3, MASK16_13);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 26;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK16_3) << 10;
            l0 |= (tmp[tmpIdx + 1] & MASK16_3) << 7;
            l0 |= (tmp[tmpIdx + 2] & MASK16_3) << 4;
            l0 |= (tmp[tmpIdx + 3] & MASK16_3) << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 4] >>> 2 & MASK16_1;
            long l1 = (tmp[tmpIdx + 4] & MASK16_2) << 11;
            l1 |= (tmp[tmpIdx + 5] & MASK16_3) << 8;
            l1 |= (tmp[tmpIdx + 6] & MASK16_3) << 5;
            l1 |= (tmp[tmpIdx + 7] & MASK16_3) << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 8] >>> 1 & MASK16_2;
            long l2 = (tmp[tmpIdx + 8] & MASK16_1) << 12;
            l2 |= (tmp[tmpIdx + 9] & MASK16_3) << 9;
            l2 |= (tmp[tmpIdx + 10] & MASK16_3) << 6;
            l2 |= (tmp[tmpIdx + 11] & MASK16_3) << 3;
            longs[longsIdx + 2] = l2 |= (tmp[tmpIdx + 12] & MASK16_3) << 0;
            ++iter;
            tmpIdx += 13;
            longsIdx += 3;
        }
    }

    private static void decode14(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 28);
        ForUtil.shiftLongs(tmp, 28, longs, 0, 2, MASK16_14);
        ForUtil.shiftLongs(tmp, 28, tmp, 0, 0, MASK16_2);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 28;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 12;
            l0 |= tmp[tmpIdx + 1] << 10;
            l0 |= tmp[tmpIdx + 2] << 8;
            l0 |= tmp[tmpIdx + 3] << 6;
            l0 |= tmp[tmpIdx + 4] << 4;
            l0 |= tmp[tmpIdx + 5] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            ++longsIdx;
        }
    }

    private static void decode15(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 30);
        ForUtil.shiftLongs(tmp, 30, longs, 0, 1, MASK16_15);
        ForUtil.shiftLongs(tmp, 30, tmp, 0, 0, MASK16_1);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 30;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 14;
            l0 |= tmp[tmpIdx + 1] << 13;
            l0 |= tmp[tmpIdx + 2] << 12;
            l0 |= tmp[tmpIdx + 3] << 11;
            l0 |= tmp[tmpIdx + 4] << 10;
            l0 |= tmp[tmpIdx + 5] << 9;
            l0 |= tmp[tmpIdx + 6] << 8;
            l0 |= tmp[tmpIdx + 7] << 7;
            l0 |= tmp[tmpIdx + 8] << 6;
            l0 |= tmp[tmpIdx + 9] << 5;
            l0 |= tmp[tmpIdx + 10] << 4;
            l0 |= tmp[tmpIdx + 11] << 3;
            l0 |= tmp[tmpIdx + 12] << 2;
            l0 |= tmp[tmpIdx + 13] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 14] << 0;
            ++iter;
            tmpIdx += 15;
            ++longsIdx;
        }
    }

    private static void decode16(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(longs, 0, 32);
    }

    private static void decode17(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 34);
        ForUtil.shiftLongs(tmp, 34, longs, 0, 15, MASK32_17);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 34;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK32_15) << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 13 & MASK32_2;
            long l1 = (tmp[tmpIdx + 1] & MASK32_13) << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 11 & MASK32_4;
            long l2 = (tmp[tmpIdx + 2] & MASK32_11) << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 9 & MASK32_6;
            long l3 = (tmp[tmpIdx + 3] & MASK32_9) << 8;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 4] >>> 7 & MASK32_8;
            long l4 = (tmp[tmpIdx + 4] & MASK32_7) << 10;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 5] >>> 5 & MASK32_10;
            long l5 = (tmp[tmpIdx + 5] & MASK32_5) << 12;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 6] >>> 3 & MASK32_12;
            long l6 = (tmp[tmpIdx + 6] & MASK32_3) << 14;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 7] >>> 1 & MASK32_14;
            long l7 = (tmp[tmpIdx + 7] & MASK32_1) << 16;
            l7 |= (tmp[tmpIdx + 8] & MASK32_15) << 1;
            longs[longsIdx + 7] = l7 |= tmp[tmpIdx + 9] >>> 14 & MASK32_1;
            long l8 = (tmp[tmpIdx + 9] & MASK32_14) << 3;
            longs[longsIdx + 8] = l8 |= tmp[tmpIdx + 10] >>> 12 & MASK32_3;
            long l9 = (tmp[tmpIdx + 10] & MASK32_12) << 5;
            longs[longsIdx + 9] = l9 |= tmp[tmpIdx + 11] >>> 10 & MASK32_5;
            long l10 = (tmp[tmpIdx + 11] & MASK32_10) << 7;
            longs[longsIdx + 10] = l10 |= tmp[tmpIdx + 12] >>> 8 & MASK32_7;
            long l11 = (tmp[tmpIdx + 12] & MASK32_8) << 9;
            longs[longsIdx + 11] = l11 |= tmp[tmpIdx + 13] >>> 6 & MASK32_9;
            long l12 = (tmp[tmpIdx + 13] & MASK32_6) << 11;
            longs[longsIdx + 12] = l12 |= tmp[tmpIdx + 14] >>> 4 & MASK32_11;
            long l13 = (tmp[tmpIdx + 14] & MASK32_4) << 13;
            longs[longsIdx + 13] = l13 |= tmp[tmpIdx + 15] >>> 2 & MASK32_13;
            long l14 = (tmp[tmpIdx + 15] & MASK32_2) << 15;
            longs[longsIdx + 14] = l14 |= (tmp[tmpIdx + 16] & MASK32_15) << 0;
            ++iter;
            tmpIdx += 17;
            longsIdx += 15;
        }
    }

    private static void decode18(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 36);
        ForUtil.shiftLongs(tmp, 36, longs, 0, 14, MASK32_18);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 36;
        while (iter < 4) {
            long l0 = (tmp[tmpIdx + 0] & MASK32_14) << 4;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 10 & MASK32_4;
            long l1 = (tmp[tmpIdx + 1] & MASK32_10) << 8;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 6 & MASK32_8;
            long l2 = (tmp[tmpIdx + 2] & MASK32_6) << 12;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 2 & MASK32_12;
            long l3 = (tmp[tmpIdx + 3] & MASK32_2) << 16;
            l3 |= (tmp[tmpIdx + 4] & MASK32_14) << 2;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 5] >>> 12 & MASK32_2;
            long l4 = (tmp[tmpIdx + 5] & MASK32_12) << 6;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 6] >>> 8 & MASK32_6;
            long l5 = (tmp[tmpIdx + 6] & MASK32_8) << 10;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 7] >>> 4 & MASK32_10;
            long l6 = (tmp[tmpIdx + 7] & MASK32_4) << 14;
            longs[longsIdx + 6] = l6 |= (tmp[tmpIdx + 8] & MASK32_14) << 0;
            ++iter;
            tmpIdx += 9;
            longsIdx += 7;
        }
    }

    private static void decode19(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 38);
        ForUtil.shiftLongs(tmp, 38, longs, 0, 13, MASK32_19);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 38;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK32_13) << 6;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 7 & MASK32_6;
            long l1 = (tmp[tmpIdx + 1] & MASK32_7) << 12;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 1 & MASK32_12;
            long l2 = (tmp[tmpIdx + 2] & MASK32_1) << 18;
            l2 |= (tmp[tmpIdx + 3] & MASK32_13) << 5;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 4] >>> 8 & MASK32_5;
            long l3 = (tmp[tmpIdx + 4] & MASK32_8) << 11;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 5] >>> 2 & MASK32_11;
            long l4 = (tmp[tmpIdx + 5] & MASK32_2) << 17;
            l4 |= (tmp[tmpIdx + 6] & MASK32_13) << 4;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 7] >>> 9 & MASK32_4;
            long l5 = (tmp[tmpIdx + 7] & MASK32_9) << 10;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 8] >>> 3 & MASK32_10;
            long l6 = (tmp[tmpIdx + 8] & MASK32_3) << 16;
            l6 |= (tmp[tmpIdx + 9] & MASK32_13) << 3;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 10] >>> 10 & MASK32_3;
            long l7 = (tmp[tmpIdx + 10] & MASK32_10) << 9;
            longs[longsIdx + 7] = l7 |= tmp[tmpIdx + 11] >>> 4 & MASK32_9;
            long l8 = (tmp[tmpIdx + 11] & MASK32_4) << 15;
            l8 |= (tmp[tmpIdx + 12] & MASK32_13) << 2;
            longs[longsIdx + 8] = l8 |= tmp[tmpIdx + 13] >>> 11 & MASK32_2;
            long l9 = (tmp[tmpIdx + 13] & MASK32_11) << 8;
            longs[longsIdx + 9] = l9 |= tmp[tmpIdx + 14] >>> 5 & MASK32_8;
            long l10 = (tmp[tmpIdx + 14] & MASK32_5) << 14;
            l10 |= (tmp[tmpIdx + 15] & MASK32_13) << 1;
            longs[longsIdx + 10] = l10 |= tmp[tmpIdx + 16] >>> 12 & MASK32_1;
            long l11 = (tmp[tmpIdx + 16] & MASK32_12) << 7;
            longs[longsIdx + 11] = l11 |= tmp[tmpIdx + 17] >>> 6 & MASK32_7;
            long l12 = (tmp[tmpIdx + 17] & MASK32_6) << 13;
            longs[longsIdx + 12] = l12 |= (tmp[tmpIdx + 18] & MASK32_13) << 0;
            ++iter;
            tmpIdx += 19;
            longsIdx += 13;
        }
    }

    private static void decode20(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 40);
        ForUtil.shiftLongs(tmp, 40, longs, 0, 12, MASK32_20);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 40;
        while (iter < 8) {
            long l0 = (tmp[tmpIdx + 0] & MASK32_12) << 8;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 4 & MASK32_8;
            long l1 = (tmp[tmpIdx + 1] & MASK32_4) << 16;
            l1 |= (tmp[tmpIdx + 2] & MASK32_12) << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 8 & MASK32_4;
            long l2 = (tmp[tmpIdx + 3] & MASK32_8) << 12;
            longs[longsIdx + 2] = l2 |= (tmp[tmpIdx + 4] & MASK32_12) << 0;
            ++iter;
            tmpIdx += 5;
            longsIdx += 3;
        }
    }

    private static void decode21(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 42);
        ForUtil.shiftLongs(tmp, 42, longs, 0, 11, MASK32_21);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 42;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK32_11) << 10;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & MASK32_10;
            long l1 = (tmp[tmpIdx + 1] & MASK32_1) << 20;
            l1 |= (tmp[tmpIdx + 2] & MASK32_11) << 9;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 2 & MASK32_9;
            long l2 = (tmp[tmpIdx + 3] & MASK32_2) << 19;
            l2 |= (tmp[tmpIdx + 4] & MASK32_11) << 8;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 5] >>> 3 & MASK32_8;
            long l3 = (tmp[tmpIdx + 5] & MASK32_3) << 18;
            l3 |= (tmp[tmpIdx + 6] & MASK32_11) << 7;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 7] >>> 4 & MASK32_7;
            long l4 = (tmp[tmpIdx + 7] & MASK32_4) << 17;
            l4 |= (tmp[tmpIdx + 8] & MASK32_11) << 6;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 9] >>> 5 & MASK32_6;
            long l5 = (tmp[tmpIdx + 9] & MASK32_5) << 16;
            l5 |= (tmp[tmpIdx + 10] & MASK32_11) << 5;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 11] >>> 6 & MASK32_5;
            long l6 = (tmp[tmpIdx + 11] & MASK32_6) << 15;
            l6 |= (tmp[tmpIdx + 12] & MASK32_11) << 4;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 13] >>> 7 & MASK32_4;
            long l7 = (tmp[tmpIdx + 13] & MASK32_7) << 14;
            l7 |= (tmp[tmpIdx + 14] & MASK32_11) << 3;
            longs[longsIdx + 7] = l7 |= tmp[tmpIdx + 15] >>> 8 & MASK32_3;
            long l8 = (tmp[tmpIdx + 15] & MASK32_8) << 13;
            l8 |= (tmp[tmpIdx + 16] & MASK32_11) << 2;
            longs[longsIdx + 8] = l8 |= tmp[tmpIdx + 17] >>> 9 & MASK32_2;
            long l9 = (tmp[tmpIdx + 17] & MASK32_9) << 12;
            l9 |= (tmp[tmpIdx + 18] & MASK32_11) << 1;
            longs[longsIdx + 9] = l9 |= tmp[tmpIdx + 19] >>> 10 & MASK32_1;
            long l10 = (tmp[tmpIdx + 19] & MASK32_10) << 11;
            longs[longsIdx + 10] = l10 |= (tmp[tmpIdx + 20] & MASK32_11) << 0;
            ++iter;
            tmpIdx += 21;
            longsIdx += 11;
        }
    }

    private static void decode22(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 44);
        ForUtil.shiftLongs(tmp, 44, longs, 0, 10, MASK32_22);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 44;
        while (iter < 4) {
            long l0 = (tmp[tmpIdx + 0] & MASK32_10) << 12;
            l0 |= (tmp[tmpIdx + 1] & MASK32_10) << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 8 & MASK32_2;
            long l1 = (tmp[tmpIdx + 2] & MASK32_8) << 14;
            l1 |= (tmp[tmpIdx + 3] & MASK32_10) << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 6 & MASK32_4;
            long l2 = (tmp[tmpIdx + 4] & MASK32_6) << 16;
            l2 |= (tmp[tmpIdx + 5] & MASK32_10) << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 4 & MASK32_6;
            long l3 = (tmp[tmpIdx + 6] & MASK32_4) << 18;
            l3 |= (tmp[tmpIdx + 7] & MASK32_10) << 8;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 2 & MASK32_8;
            long l4 = (tmp[tmpIdx + 8] & MASK32_2) << 20;
            l4 |= (tmp[tmpIdx + 9] & MASK32_10) << 10;
            longs[longsIdx + 4] = l4 |= (tmp[tmpIdx + 10] & MASK32_10) << 0;
            ++iter;
            tmpIdx += 11;
            longsIdx += 5;
        }
    }

    private static void decode23(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 46);
        ForUtil.shiftLongs(tmp, 46, longs, 0, 9, MASK32_23);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 46;
        while (iter < 2) {
            long l0 = (tmp[tmpIdx + 0] & MASK32_9) << 14;
            l0 |= (tmp[tmpIdx + 1] & MASK32_9) << 5;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 4 & MASK32_5;
            long l1 = (tmp[tmpIdx + 2] & MASK32_4) << 19;
            l1 |= (tmp[tmpIdx + 3] & MASK32_9) << 10;
            l1 |= (tmp[tmpIdx + 4] & MASK32_9) << 1;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 5] >>> 8 & MASK32_1;
            long l2 = (tmp[tmpIdx + 5] & MASK32_8) << 15;
            l2 |= (tmp[tmpIdx + 6] & MASK32_9) << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 7] >>> 3 & MASK32_6;
            long l3 = (tmp[tmpIdx + 7] & MASK32_3) << 20;
            l3 |= (tmp[tmpIdx + 8] & MASK32_9) << 11;
            l3 |= (tmp[tmpIdx + 9] & MASK32_9) << 2;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 10] >>> 7 & MASK32_2;
            long l4 = (tmp[tmpIdx + 10] & MASK32_7) << 16;
            l4 |= (tmp[tmpIdx + 11] & MASK32_9) << 7;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 12] >>> 2 & MASK32_7;
            long l5 = (tmp[tmpIdx + 12] & MASK32_2) << 21;
            l5 |= (tmp[tmpIdx + 13] & MASK32_9) << 12;
            l5 |= (tmp[tmpIdx + 14] & MASK32_9) << 3;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 15] >>> 6 & MASK32_3;
            long l6 = (tmp[tmpIdx + 15] & MASK32_6) << 17;
            l6 |= (tmp[tmpIdx + 16] & MASK32_9) << 8;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 17] >>> 1 & MASK32_8;
            long l7 = (tmp[tmpIdx + 17] & MASK32_1) << 22;
            l7 |= (tmp[tmpIdx + 18] & MASK32_9) << 13;
            l7 |= (tmp[tmpIdx + 19] & MASK32_9) << 4;
            longs[longsIdx + 7] = l7 |= tmp[tmpIdx + 20] >>> 5 & MASK32_4;
            long l8 = (tmp[tmpIdx + 20] & MASK32_5) << 18;
            l8 |= (tmp[tmpIdx + 21] & MASK32_9) << 9;
            longs[longsIdx + 8] = l8 |= (tmp[tmpIdx + 22] & MASK32_9) << 0;
            ++iter;
            tmpIdx += 23;
            longsIdx += 9;
        }
    }

    private static void decode24(DataInput in, long[] tmp, long[] longs) throws IOException {
        in.readLongs(tmp, 0, 48);
        ForUtil.shiftLongs(tmp, 48, longs, 0, 8, MASK32_24);
        ForUtil.shiftLongs(tmp, 48, tmp, 0, 0, MASK32_8);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 48;
        while (iter < 16) {
            long l0 = tmp[tmpIdx + 0] << 16;
            l0 |= tmp[tmpIdx + 1] << 8;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            ++longsIdx;
        }
    }

    static {
        int i;
        MASKS8 = new long[8];
        MASKS16 = new long[16];
        MASKS32 = new long[32];
        for (i = 0; i < 8; ++i) {
            ForUtil.MASKS8[i] = ForUtil.mask8(i);
        }
        for (i = 0; i < 16; ++i) {
            ForUtil.MASKS16[i] = ForUtil.mask16(i);
        }
        for (i = 0; i < 32; ++i) {
            ForUtil.MASKS32[i] = ForUtil.mask32(i);
        }
        MASK8_1 = MASKS8[1];
        MASK8_2 = MASKS8[2];
        MASK8_3 = MASKS8[3];
        MASK8_4 = MASKS8[4];
        MASK8_5 = MASKS8[5];
        MASK8_6 = MASKS8[6];
        MASK8_7 = MASKS8[7];
        MASK16_1 = MASKS16[1];
        MASK16_2 = MASKS16[2];
        MASK16_3 = MASKS16[3];
        MASK16_4 = MASKS16[4];
        MASK16_5 = MASKS16[5];
        MASK16_6 = MASKS16[6];
        MASK16_7 = MASKS16[7];
        MASK16_9 = MASKS16[9];
        MASK16_10 = MASKS16[10];
        MASK16_11 = MASKS16[11];
        MASK16_12 = MASKS16[12];
        MASK16_13 = MASKS16[13];
        MASK16_14 = MASKS16[14];
        MASK16_15 = MASKS16[15];
        MASK32_1 = MASKS32[1];
        MASK32_2 = MASKS32[2];
        MASK32_3 = MASKS32[3];
        MASK32_4 = MASKS32[4];
        MASK32_5 = MASKS32[5];
        MASK32_6 = MASKS32[6];
        MASK32_7 = MASKS32[7];
        MASK32_8 = MASKS32[8];
        MASK32_9 = MASKS32[9];
        MASK32_10 = MASKS32[10];
        MASK32_11 = MASKS32[11];
        MASK32_12 = MASKS32[12];
        MASK32_13 = MASKS32[13];
        MASK32_14 = MASKS32[14];
        MASK32_15 = MASKS32[15];
        MASK32_17 = MASKS32[17];
        MASK32_18 = MASKS32[18];
        MASK32_19 = MASKS32[19];
        MASK32_20 = MASKS32[20];
        MASK32_21 = MASKS32[21];
        MASK32_22 = MASKS32[22];
        MASK32_23 = MASKS32[23];
        MASK32_24 = MASKS32[24];
    }
}

