/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.util.ArrayList;
import java.util.PrimitiveIterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;

public class AutomatonQueries {
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';
    public static final char WILDCARD_ESCAPE = '\\';

    public static Automaton caseInsensitivePrefix(String s) {
        ArrayList<Automaton> list = new ArrayList<Automaton>();
        PrimitiveIterator.OfInt iter = s.codePoints().iterator();
        while (iter.hasNext()) {
            list.add(AutomatonQueries.toCaseInsensitiveChar((Integer)iter.next()));
        }
        list.add(Automata.makeAnyString());
        Automaton a = Operations.concatenate(list);
        assert (a.isDeterministic());
        a = MinimizationOperations.minimize((Automaton)a, (int)0);
        assert (a.isDeterministic());
        return a;
    }

    public static AutomatonQuery caseInsensitivePrefixQuery(Term prefix) {
        return new AutomatonQuery(prefix, AutomatonQueries.caseInsensitivePrefix(prefix.text()));
    }

    public static AutomatonQuery caseInsensitiveTermQuery(Term term) {
        BytesRef prefix = term.bytes();
        return new AutomatonQuery(term, AutomatonQueries.toCaseInsensitiveString(prefix));
    }

    public static AutomatonQuery caseInsensitiveWildcardQuery(Term wildcardquery) {
        return new AutomatonQuery(wildcardquery, AutomatonQueries.toCaseInsensitiveWildcardAutomaton(wildcardquery));
    }

    public static Automaton toCaseInsensitiveWildcardAutomaton(Term wildcardquery) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        String wildcardText = wildcardquery.text();
        block5: for (int i = 0; i < wildcardText.length(); i += length) {
            int c = wildcardText.codePointAt(i);
            length = Character.charCount(c);
            switch (c) {
                case 42: {
                    automata.add(Automata.makeAnyString());
                    continue block5;
                }
                case 63: {
                    automata.add(Automata.makeAnyChar());
                    continue block5;
                }
                case 92: {
                    if (i + length < wildcardText.length()) {
                        int nextChar = wildcardText.codePointAt(i + length);
                        length += Character.charCount(nextChar);
                        automata.add(Automata.makeChar((int)nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(AutomatonQueries.toCaseInsensitiveChar(c));
                }
            }
        }
        return Operations.concatenate(automata);
    }

    protected static Automaton toCaseInsensitiveString(BytesRef br) {
        return AutomatonQueries.toCaseInsensitiveString(br.utf8ToString());
    }

    public static Automaton toCaseInsensitiveString(String s) {
        ArrayList<Automaton> list = new ArrayList<Automaton>();
        PrimitiveIterator.OfInt iter = s.codePoints().iterator();
        while (iter.hasNext()) {
            list.add(AutomatonQueries.toCaseInsensitiveChar((Integer)iter.next()));
        }
        Automaton a = Operations.concatenate(list);
        assert (a.isDeterministic());
        a = MinimizationOperations.minimize((Automaton)a, (int)0);
        return a;
    }

    public static Automaton toCaseInsensitiveChar(int codepoint) {
        Automaton result;
        int altCase;
        Automaton case1 = Automata.makeChar((int)codepoint);
        if (codepoint > 128) {
            return case1;
        }
        int n = altCase = Character.isLowerCase(codepoint) ? Character.toUpperCase(codepoint) : Character.toLowerCase(codepoint);
        if (altCase != codepoint) {
            result = Operations.union((Automaton)case1, (Automaton)Automata.makeChar((int)altCase));
            result = MinimizationOperations.minimize((Automaton)result, (int)0);
            assert (result.isDeterministic());
        } else {
            result = case1;
        }
        return result;
    }
}

