/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.downsample;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.action.downsample.DownsampleTask;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DownsampleAction
extends ActionType<AcknowledgedResponse> {
    public static final DownsampleAction INSTANCE = new DownsampleAction();
    public static final String NAME = "indices:admin/xpack/downsample";
    public static final TimeValue DEFAULT_WAIT_TIMEOUT = new TimeValue(1L, TimeUnit.DAYS);

    private DownsampleAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private String sourceIndex;
        private String targetIndex;
        private TimeValue waitTimeout;
        private DownsampleConfig downsampleConfig;

        public Request(String sourceIndex, String targetIndex, TimeValue waitTimeout, DownsampleConfig downsampleConfig) {
            this.sourceIndex = sourceIndex;
            this.targetIndex = targetIndex;
            this.waitTimeout = waitTimeout == null ? DEFAULT_WAIT_TIMEOUT : waitTimeout;
            this.downsampleConfig = downsampleConfig;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.sourceIndex = in.readString();
            this.targetIndex = in.readString();
            this.waitTimeout = in.getTransportVersion().onOrAfter(TransportVersions.V_8_500_054) ? TimeValue.parseTimeValue((String)in.readString(), (String)"timeout") : DEFAULT_WAIT_TIMEOUT;
            this.downsampleConfig = new DownsampleConfig(in);
        }

        @Override
        public String[] indices() {
            return new String[]{this.sourceIndex};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new DownsampleTask(id, type, action, parentTaskId, this.targetIndex, this.downsampleConfig, headers);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sourceIndex);
            out.writeString(this.targetIndex);
            out.writeString(out.getTransportVersion().onOrAfter(TransportVersions.V_8_500_054) ? this.waitTimeout.getStringRep() : DEFAULT_WAIT_TIMEOUT.getStringRep());
            this.downsampleConfig.writeTo(out);
        }

        public String getSourceIndex() {
            return this.sourceIndex;
        }

        public String getTargetIndex() {
            return this.targetIndex;
        }

        public TimeValue getWaitTimeout() {
            return this.waitTimeout;
        }

        public DownsampleConfig getDownsampleConfig() {
            return this.downsampleConfig;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.sourceIndex == null) {
                validationException = ValidateActions.addValidationError("source index is missing", validationException);
            }
            if (this.targetIndex == null) {
                validationException = ValidateActions.addValidationError("target index name is missing", validationException);
            }
            if (this.downsampleConfig == null) {
                validationException = ValidateActions.addValidationError("downsample configuration is missing", validationException);
            }
            return validationException;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("source_index", this.sourceIndex);
            builder.field("target_index", this.targetIndex);
            builder.field("wait_timeout", (Object)this.waitTimeout);
            this.downsampleConfig.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.sourceIndex, this.targetIndex, this.waitTimeout, this.downsampleConfig);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.sourceIndex, other.sourceIndex) && Objects.equals(this.targetIndex, other.targetIndex) && Objects.equals(this.waitTimeout, other.waitTimeout) && Objects.equals(this.downsampleConfig, other.downsampleConfig);
        }
    }
}

