/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.SimulateBulkAction;
import org.elasticsearch.action.bulk.SimulateBulkRequest;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.SimulateIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.SimulateIngestService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSimulateBulkAction
extends TransportBulkAction {
    @Inject
    public TransportSimulateBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        super(SimulateBulkAction.INSTANCE, SimulateBulkRequest::new, threadPool, transportService, clusterService, ingestService, client, actionFilters, indexNameExpressionResolver, indexingPressure, systemIndices, System::nanoTime);
    }

    @Override
    protected void createMissingIndicesAndIndexData(Task task, BulkRequest bulkRequest, String executorName, ActionListener<BulkResponse> listener, Set<String> autoCreateIndices, Map<String, IndexNotFoundException> indicesThatCannotBeCreated, long startTime) {
        AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            DocWriteRequest<?> request = bulkRequest.requests.get(i);
            assert (request instanceof IndexRequest);
            responses.set(i, BulkItemResponse.success(0, DocWriteRequest.OpType.CREATE, new SimulateIndexResponse(request.id(), request.index(), request.version(), ((IndexRequest)request).source(), ((IndexRequest)request).getContentType(), ((IndexRequest)request).getExecutedPipelines())));
        }
        listener.onResponse(new BulkResponse(responses.toArray(new BulkItemResponse[responses.length()]), this.buildTookInMillis(startTime)));
    }

    @Override
    protected IngestService getIngestService(BulkRequest request) {
        IngestService rawIngestService = super.getIngestService(request);
        return new SimulateIngestService(rawIngestService, request);
    }
}

