/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class ClusterGetSettingsAction
extends ActionType<Response> {
    public static final ClusterGetSettingsAction INSTANCE = new ClusterGetSettingsAction();
    public static final String NAME = "cluster:monitor/settings";

    public ClusterGetSettingsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse {
        private final Settings persistentSettings;
        private final Settings transientSettings;
        private final Settings settings;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.persistentSettings, response.persistentSettings) && Objects.equals(this.transientSettings, response.transientSettings) && Objects.equals(this.settings, response.settings);
        }

        public int hashCode() {
            return Objects.hash(this.persistentSettings, this.transientSettings, this.settings);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            assert (in.getTransportVersion().onOrAfter(TransportVersions.V_8_3_0));
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.settings = Settings.readSettingsFromStream(in);
        }

        public Response(Settings persistentSettings, Settings transientSettings, Settings settings) {
            this.persistentSettings = Objects.requireNonNullElse(persistentSettings, Settings.EMPTY);
            this.transientSettings = Objects.requireNonNullElse(transientSettings, Settings.EMPTY);
            this.settings = Objects.requireNonNullElse(settings, Settings.EMPTY);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getTransportVersion().onOrAfter(TransportVersions.V_8_3_0));
            this.persistentSettings.writeTo(out);
            this.transientSettings.writeTo(out);
            this.settings.writeTo(out);
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Settings settings() {
            return this.settings;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            assert (in.getTransportVersion().onOrAfter(TransportVersions.V_8_3_0));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getTransportVersion().onOrAfter(TransportVersions.V_8_3_0));
            super.writeTo(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

