/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class Derivative
extends InternalSimpleValue {
    private final double normalizationFactor;

    Derivative(String name, double value, double normalizationFactor, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, value, formatter, metadata);
        this.normalizationFactor = normalizationFactor;
    }

    public Derivative(StreamInput in) throws IOException {
        super(in);
        this.normalizationFactor = in.readDouble();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeDouble(this.normalizationFactor);
    }

    public String getWriteableName() {
        return "derivative";
    }

    public double normalizedValue() {
        return this.normalizationFactor > 0.0 ? this.value() / this.normalizationFactor : this.value();
    }

    DocValueFormat formatter() {
        return this.format;
    }

    double getNormalizationFactor() {
        return this.normalizationFactor;
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.value();
        }
        if (path.size() == 1 && "normalized_value".equals(path.get(0))) {
            return this.normalizedValue();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, params);
        if (this.normalizationFactor > 0.0) {
            boolean hasValue = !(Double.isInfinite(this.normalizedValue()) || Double.isNaN(this.normalizedValue()));
            builder.field("normalized_value", hasValue ? Double.valueOf(this.normalizedValue()) : null);
            if (hasValue && this.format != DocValueFormat.RAW) {
                builder.field("normalized_value_as_string", this.format.format(this.normalizedValue()));
            }
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.normalizationFactor, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Derivative other = (Derivative)((Object)obj);
        return Objects.equals(this.value, other.value) && Objects.equals(this.normalizationFactor, other.normalizationFactor);
    }
}

