/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.index.Index;

final class IndexAllocation {
    private IndexAllocation() {
    }

    static boolean isAnyAssignedToNode(ClusterState state, List<Index> indices, Predicate<DiscoveryNode> nodePredicate) {
        for (Index index : indices) {
            IndexRoutingTable routingTable;
            IndexMetadata metadata = state.getMetadata().index(index);
            if (metadata == null || (routingTable = state.routingTable().index(index)) == null) continue;
            for (ShardRouting shardRouting : routingTable.randomAllActiveShardsIt()) {
                DiscoveryNode assignedNode;
                if (!shardRouting.assignedToNode() || !nodePredicate.test(assignedNode = state.nodes().get(shardRouting.currentNodeId()))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isAnyOnWarmOrColdTier(ClusterState state, List<Index> indices) {
        return IndexAllocation.isAnyAssignedToNode(state, indices, n -> !DataTier.isContentNode((DiscoveryNode)n) && (DataTier.isWarmNode((DiscoveryNode)n) || DataTier.isColdNode((DiscoveryNode)n)));
    }
}

