/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;

public class GetFlamegraphResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final int size;
    private final double samplingRate;
    private final long selfCPU;
    private final long totalCPU;
    private final long totalSamples;
    private final List<Map<String, Integer>> edges;
    private final List<String> fileIds;
    private final List<Integer> frameTypes;
    private final List<Boolean> inlineFrames;
    private final List<String> fileNames;
    private final List<Integer> addressOrLines;
    private final List<String> functionNames;
    private final List<Integer> functionOffsets;
    private final List<String> sourceFileNames;
    private final List<Integer> sourceLines;
    private final List<Long> countInclusive;
    private final List<Long> countExclusive;
    private final List<Double> annualCO2TonsInclusive;
    private final List<Double> annualCO2TonsExclusive;
    private final List<Double> annualCostsUSDInclusive;
    private final List<Double> annualCostsUSDExclusive;

    public GetFlamegraphResponse(StreamInput in) throws IOException {
        this.size = in.readInt();
        this.samplingRate = in.readDouble();
        this.edges = in.readCollectionAsList(i -> i.readMap(StreamInput::readInt));
        this.fileIds = in.readCollectionAsList(StreamInput::readString);
        this.frameTypes = in.readCollectionAsList(StreamInput::readInt);
        this.inlineFrames = in.readCollectionAsList(StreamInput::readBoolean);
        this.fileNames = in.readCollectionAsList(StreamInput::readString);
        this.addressOrLines = in.readCollectionAsList(StreamInput::readInt);
        this.functionNames = in.readCollectionAsList(StreamInput::readString);
        this.functionOffsets = in.readCollectionAsList(StreamInput::readInt);
        this.sourceFileNames = in.readCollectionAsList(StreamInput::readString);
        this.sourceLines = in.readCollectionAsList(StreamInput::readInt);
        this.countInclusive = in.readCollectionAsList(StreamInput::readLong);
        this.countExclusive = in.readCollectionAsList(StreamInput::readLong);
        this.annualCO2TonsInclusive = in.readCollectionAsList(StreamInput::readDouble);
        this.annualCO2TonsExclusive = in.readCollectionAsList(StreamInput::readDouble);
        this.annualCostsUSDInclusive = in.readCollectionAsList(StreamInput::readDouble);
        this.annualCostsUSDExclusive = in.readCollectionAsList(StreamInput::readDouble);
        this.selfCPU = in.readLong();
        this.totalCPU = in.readLong();
        this.totalSamples = in.readLong();
    }

    public GetFlamegraphResponse(int size, double samplingRate, List<Map<String, Integer>> edges, List<String> fileIds, List<Integer> frameTypes, List<Boolean> inlineFrames, List<String> fileNames, List<Integer> addressOrLines, List<String> functionNames, List<Integer> functionOffsets, List<String> sourceFileNames, List<Integer> sourceLines, List<Long> countInclusive, List<Long> countExclusive, List<Double> annualCO2TonsInclusive, List<Double> annualCO2TonsExclusive, List<Double> annualCostsUSDInclusive, List<Double> annualCostsUSDExclusive, long selfCPU, long totalCPU, long totalSamples) {
        this.size = size;
        this.samplingRate = samplingRate;
        this.edges = edges;
        this.fileIds = fileIds;
        this.frameTypes = frameTypes;
        this.inlineFrames = inlineFrames;
        this.fileNames = fileNames;
        this.addressOrLines = addressOrLines;
        this.functionNames = functionNames;
        this.functionOffsets = functionOffsets;
        this.sourceFileNames = sourceFileNames;
        this.sourceLines = sourceLines;
        this.countInclusive = countInclusive;
        this.countExclusive = countExclusive;
        this.annualCO2TonsInclusive = annualCO2TonsInclusive;
        this.annualCO2TonsExclusive = annualCO2TonsExclusive;
        this.annualCostsUSDInclusive = annualCostsUSDInclusive;
        this.annualCostsUSDExclusive = annualCostsUSDExclusive;
        this.selfCPU = selfCPU;
        this.totalCPU = totalCPU;
        this.totalSamples = totalSamples;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeDouble(this.samplingRate);
        out.writeCollection(this.edges, (o, v) -> o.writeMap(v, StreamOutput::writeString, StreamOutput::writeInt));
        out.writeCollection(this.fileIds, StreamOutput::writeString);
        out.writeCollection(this.frameTypes, StreamOutput::writeInt);
        out.writeCollection(this.inlineFrames, StreamOutput::writeBoolean);
        out.writeCollection(this.fileNames, StreamOutput::writeString);
        out.writeCollection(this.addressOrLines, StreamOutput::writeInt);
        out.writeCollection(this.functionNames, StreamOutput::writeString);
        out.writeCollection(this.functionOffsets, StreamOutput::writeInt);
        out.writeCollection(this.sourceFileNames, StreamOutput::writeString);
        out.writeCollection(this.sourceLines, StreamOutput::writeInt);
        out.writeCollection(this.countInclusive, StreamOutput::writeLong);
        out.writeCollection(this.countExclusive, StreamOutput::writeLong);
        out.writeCollection(this.annualCO2TonsInclusive, StreamOutput::writeDouble);
        out.writeCollection(this.annualCO2TonsExclusive, StreamOutput::writeDouble);
        out.writeCollection(this.annualCostsUSDInclusive, StreamOutput::writeDouble);
        out.writeCollection(this.annualCostsUSDExclusive, StreamOutput::writeDouble);
        out.writeLong(this.selfCPU);
        out.writeLong(this.totalCPU);
        out.writeLong(this.totalSamples);
    }

    public int getSize() {
        return this.size;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public List<Long> getCountInclusive() {
        return this.countInclusive;
    }

    public List<Long> getCountExclusive() {
        return this.countExclusive;
    }

    public List<Map<String, Integer>> getEdges() {
        return this.edges;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public List<Integer> getFrameTypes() {
        return this.frameTypes;
    }

    public List<Boolean> getInlineFrames() {
        return this.inlineFrames;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public List<Integer> getAddressOrLines() {
        return this.addressOrLines;
    }

    public List<String> getFunctionNames() {
        return this.functionNames;
    }

    public List<Integer> getFunctionOffsets() {
        return this.functionOffsets;
    }

    public List<String> getSourceFileNames() {
        return this.sourceFileNames;
    }

    public List<Integer> getSourceLines() {
        return this.sourceLines;
    }

    public List<Double> getAnnualCO2TonsInclusive() {
        return this.annualCO2TonsInclusive;
    }

    public List<Double> getAnnualCostsUSDInclusive() {
        return this.annualCostsUSDInclusive;
    }

    public long getSelfCPU() {
        return this.selfCPU;
    }

    public long getTotalCPU() {
        return this.totalCPU;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.array((String)"Edges", (Iterator)Iterators.flatMap(this.edges.iterator(), perNodeEdges -> Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startArray(), Iterators.map(perNodeEdges.entrySet().iterator(), edge -> (b, p) -> b.value((Integer)edge.getValue())), ChunkedToXContentHelper.endArray()}))), ChunkedToXContentHelper.array((String)"FileID", (Iterator)Iterators.map(this.fileIds.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"FrameType", (Iterator)Iterators.map(this.frameTypes.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"Inline", (Iterator)Iterators.map(this.inlineFrames.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"ExeFilename", (Iterator)Iterators.map(this.fileNames.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"AddressOrLine", (Iterator)Iterators.map(this.addressOrLines.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"FunctionName", (Iterator)Iterators.map(this.functionNames.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"FunctionOffset", (Iterator)Iterators.map(this.functionOffsets.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"SourceFilename", (Iterator)Iterators.map(this.sourceFileNames.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"SourceLine", (Iterator)Iterators.map(this.sourceLines.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"CountInclusive", (Iterator)Iterators.map(this.countInclusive.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"CountExclusive", (Iterator)Iterators.map(this.countExclusive.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"AnnualCO2TonsInclusive", (Iterator)Iterators.map(this.annualCO2TonsInclusive.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"AnnualCO2TonsExclusive", (Iterator)Iterators.map(this.annualCO2TonsExclusive.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"AnnualCostsUSDInclusive", (Iterator)Iterators.map(this.annualCostsUSDInclusive.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"AnnualCostsUSDExclusive", (Iterator)Iterators.map(this.annualCostsUSDExclusive.iterator(), e -> (b, p) -> b.value(e))), Iterators.single((b, p) -> b.field("Size", this.size)), Iterators.single((b, p) -> b.field("SamplingRate", this.samplingRate)), Iterators.single((b, p) -> b.field("SelfCPU", this.selfCPU)), Iterators.single((b, p) -> b.field("TotalCPU", this.totalCPU)), Iterators.single((b, p) -> b.field("TotalSamples", this.totalSamples)), ChunkedToXContentHelper.endObject()});
    }
}

