/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.util;

import java.util.Locale;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.XYEncodingUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownText;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SpatialCoordinateTypes {
    GEO{

        @Override
        public SpatialPoint longAsPoint(long encoded) {
            return new GeoPoint(GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))), GeoEncodingUtils.decodeLongitude((int)((int)encoded)));
        }

        @Override
        public long pointAsLong(double x, double y) {
            int latitudeEncoded = GeoEncodingUtils.encodeLatitude((double)y);
            int longitudeEncoded = GeoEncodingUtils.encodeLongitude((double)x);
            return (long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL;
        }

        @Override
        public SpatialPoint pointAsPoint(Point point) {
            return new GeoPoint(point.getY(), point.getX());
        }
    }
    ,
    CARTESIAN{

        @Override
        public SpatialPoint longAsPoint(long encoded) {
            double x = XYEncodingUtils.decode((int)((int)(encoded >>> 32)));
            double y = XYEncodingUtils.decode((int)((int)(encoded & 0xFFFFFFFFFFFFFFFFL)));
            return this.makePoint(x, y);
        }

        @Override
        public long pointAsLong(double x, double y) {
            long xi = XYEncodingUtils.encode((float)((float)x));
            long yi = XYEncodingUtils.encode((float)((float)y));
            return yi & 0xFFFFFFFFL | xi << 32;
        }

        @Override
        public SpatialPoint pointAsPoint(Point point) {
            return this.makePoint(point.getX(), point.getY());
        }

        private SpatialPoint makePoint(final double x, final double y) {
            return new SpatialPoint(){

                public double getX() {
                    return x;
                }

                public double getY() {
                    return y;
                }

                public int hashCode() {
                    return 31 * Double.hashCode(x) + Double.hashCode(y);
                }

                public boolean equals(Object obj) {
                    if (obj == null) {
                        return false;
                    }
                    if (obj instanceof SpatialPoint) {
                        SpatialPoint other = (SpatialPoint)obj;
                        return x == other.getX() && y == other.getY();
                    }
                    return false;
                }

                public String toString() {
                    return String.format(Locale.ROOT, "POINT (%f %f)", x, y);
                }
            };
        }
    };


    public abstract SpatialPoint longAsPoint(long var1);

    public long pointAsLong(SpatialPoint point) {
        return this.pointAsLong(point.getX(), point.getY());
    }

    public abstract long pointAsLong(double var1, double var3);

    public String pointAsString(SpatialPoint point) {
        return WellKnownText.toWKT((Geometry)new Point(point.getX(), point.getY()));
    }

    public SpatialPoint stringAsPoint(String string) {
        try {
            Geometry geometry = WellKnownText.fromWKT((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (String)string);
            if (geometry instanceof Point) {
                Point point = (Point)geometry;
                return this.pointAsPoint(point);
            }
            throw new IllegalArgumentException("Unsupported geometry type " + geometry.type());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse WKT: " + e.getMessage(), e);
        }
    }

    public abstract SpatialPoint pointAsPoint(Point var1);
}

