/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.processor;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.ConstantNamedWriteable;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.versionfield.Version;

public class ConstantProcessor
implements Processor {
    public static String NAME = "c";
    private Object constant;
    private final Type type;

    public ConstantProcessor(Object value) {
        this.constant = value;
        this.type = value instanceof NamedWriteable ? Type.NAMED_WRITABLE : (value instanceof ZonedDateTime ? Type.ZONEDDATETIME : (value instanceof Version ? Type.VERSION : Type.GENERIC));
    }

    public ConstantProcessor(StreamInput in) throws IOException {
        this.type = (Type)in.readEnum(Type.class);
        switch (this.type) {
            case NAMED_WRITABLE: {
                this.constant = in.readNamedWriteable(ConstantNamedWriteable.class);
                break;
            }
            case ZONEDDATETIME: {
                ZoneId zoneId = in.readZoneId();
                ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(in.readLong()), zoneId);
                this.constant = zdt.withNano(in.readInt());
                break;
            }
            case VERSION: {
                this.constant = new Version(in.readString());
                break;
            }
            case GENERIC: {
                this.constant = in.readGenericValue();
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.type);
        switch (this.type) {
            case NAMED_WRITABLE: {
                out.writeNamedWriteable((NamedWriteable)this.constant);
                break;
            }
            case ZONEDDATETIME: {
                ZonedDateTime zdt = (ZonedDateTime)this.constant;
                out.writeZoneId(zdt.getZone());
                out.writeLong(zdt.toInstant().toEpochMilli());
                out.writeInt(zdt.getNano());
                break;
            }
            case VERSION: {
                out.writeString(this.constant.toString());
                break;
            }
            case GENERIC: {
                out.writeGenericValue(this.constant);
            }
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        return this.constant;
    }

    public int hashCode() {
        return Objects.hashCode(this.constant);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantProcessor other = (ConstantProcessor)obj;
        return Objects.equals(this.constant, other.constant);
    }

    public String toString() {
        return "^" + this.constant;
    }

    static enum Type {
        NAMED_WRITABLE,
        ZONEDDATETIME,
        GENERIC,
        VERSION;

    }
}

