/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent.support.filtering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.core.Glob;

public class FilterPath {
    private static final String WILDCARD = "*";
    private static final String DOUBLE_WILDCARD = "**";
    private final Map<String, FilterPath> termsChildren;
    private final FilterPath[] wildcardChildren;
    private final String pattern;
    private final boolean isDoubleWildcard;
    private final boolean isFinalNode;

    private FilterPath(String pattern, boolean isFinalNode, Map<String, FilterPath> termsChildren, FilterPath[] wildcardChildren) {
        this.pattern = pattern;
        this.isFinalNode = isFinalNode;
        this.termsChildren = Collections.unmodifiableMap(termsChildren);
        this.wildcardChildren = wildcardChildren;
        this.isDoubleWildcard = pattern.equals(DOUBLE_WILDCARD);
    }

    public boolean hasDoubleWildcard() {
        if (this.isDoubleWildcard || this.pattern.contains(DOUBLE_WILDCARD)) {
            return true;
        }
        for (FilterPath filterPath : this.wildcardChildren) {
            if (!filterPath.hasDoubleWildcard()) continue;
            return true;
        }
        for (FilterPath filterPath : this.termsChildren.values()) {
            if (!filterPath.hasDoubleWildcard()) continue;
            return true;
        }
        return false;
    }

    private String getPattern() {
        return this.pattern;
    }

    private boolean isFinalNode() {
        return this.isFinalNode;
    }

    public boolean matches(String name, List<FilterPath> nextFilters, boolean matchFieldNamesWithDots) {
        int dotIndex;
        if (nextFilters == null) {
            return false;
        }
        if (matchFieldNamesWithDots && (dotIndex = name.indexOf(46)) != -1 && dotIndex != 0 && dotIndex != name.length() - 1) {
            return this.matchFieldNamesWithDots(name, dotIndex, nextFilters);
        }
        FilterPath termNode = this.termsChildren.get(name);
        if (termNode != null) {
            if (termNode.isFinalNode()) {
                return true;
            }
            nextFilters.add(termNode);
        }
        for (FilterPath wildcardNode : this.wildcardChildren) {
            String wildcardPattern = wildcardNode.getPattern();
            if (!Glob.globMatch((String)wildcardPattern, (String)name)) continue;
            if (wildcardNode.isFinalNode()) {
                return true;
            }
            nextFilters.add(wildcardNode);
        }
        if (this.isDoubleWildcard) {
            nextFilters.add(this);
        }
        return false;
    }

    private boolean matchFieldNamesWithDots(String name, int dotIndex, List<FilterPath> nextFilters) {
        String prefixName = name.substring(0, dotIndex);
        String suffixName = name.substring(dotIndex + 1);
        ArrayList<FilterPath> prefixFilterPath = new ArrayList<FilterPath>();
        boolean prefixMatch = this.matches(prefixName, prefixFilterPath, true);
        if (prefixMatch) {
            return true;
        }
        for (FilterPath filter : prefixFilterPath) {
            boolean matches = filter.matches(suffixName, nextFilters, true);
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public static FilterPath[] compile(Set<String> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        FilterPathBuilder builder = new FilterPathBuilder();
        for (String filter : filters) {
            if (filter == null || (filter = filter.trim()).length() <= 0) continue;
            builder.insert(filter);
        }
        FilterPath filterPath = builder.build();
        return Collections.singletonList(filterPath).toArray(new FilterPath[0]);
    }

    private static class FilterPathBuilder {
        private final BuildNode root = new BuildNode(false);

        private FilterPathBuilder() {
        }

        void insert(String filter) {
            FilterPathBuilder.insertNode(filter, this.root);
        }

        FilterPath build() {
            return FilterPathBuilder.buildPath("", this.root);
        }

        static void insertNode(String filter, BuildNode node) {
            int end = filter.length();
            int splitPosition = -1;
            boolean findEscapes = false;
            for (int i = 0; i < end; ++i) {
                char c = filter.charAt(i);
                if (c == '.') {
                    splitPosition = i;
                    break;
                }
                if (c != '\\' || i + 1 >= end || filter.charAt(i + 1) != '.') continue;
                ++i;
                findEscapes = true;
            }
            if (splitPosition > 0) {
                String field = findEscapes ? filter.substring(0, splitPosition).replaceAll("\\\\.", ".") : filter.substring(0, splitPosition);
                BuildNode child = node.children.get(field);
                if (child == null) {
                    child = new BuildNode(false);
                    node.children.put(field, child);
                }
                if (!child.isFinalNode) {
                    FilterPathBuilder.insertNode(filter.substring(splitPosition + 1), child);
                }
            } else {
                String field = findEscapes ? filter.replaceAll("\\\\.", ".") : filter;
                node.children.put(field, new BuildNode(true));
            }
        }

        static FilterPath buildPath(String segment, BuildNode node) {
            HashMap<String, FilterPath> termsChildren = new HashMap<String, FilterPath>();
            ArrayList<FilterPath> wildcardChildren = new ArrayList<FilterPath>();
            for (Map.Entry<String, BuildNode> entry : node.children.entrySet()) {
                String childName = entry.getKey();
                BuildNode childNode = entry.getValue();
                FilterPath childFilterPath = FilterPathBuilder.buildPath(childName, childNode);
                if (childName.contains(FilterPath.WILDCARD)) {
                    wildcardChildren.add(childFilterPath);
                    continue;
                }
                termsChildren.put(childName, childFilterPath);
            }
            return new FilterPath(segment, node.isFinalNode, termsChildren, wildcardChildren.toArray(new FilterPath[0]));
        }

        private static class BuildNode {
            private final Map<String, BuildNode> children = new HashMap<String, BuildNode>();
            private final boolean isFinalNode;

            BuildNode(boolean isFinalNode) {
                this.isFinalNode = isFinalNode;
            }
        }
    }
}

