/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPReadWriteConnectionPool
implements LDAPInterface,
Closeable {
    @NotNull
    private final LDAPConnectionPool readPool;
    @NotNull
    private final LDAPConnectionPool writePool;

    public LDAPReadWriteConnectionPool(@NotNull LDAPConnection readConnection, int initialReadConnections, int maxReadConnections, @NotNull LDAPConnection writeConnection, int initialWriteConnections, int maxWriteConnections) throws LDAPException {
        Validator.ensureNotNull(readConnection, writeConnection);
        Validator.ensureTrue(initialReadConnections >= 1, "LDAPReadWriteConnectionPool.initialReadConnections must be at least 1.");
        Validator.ensureTrue(maxReadConnections >= initialReadConnections, "LDAPReadWriteConnectionPool.initialReadConnections must not be greater than maxReadConnections.");
        Validator.ensureTrue(initialWriteConnections >= 1, "LDAPReadWriteConnectionPool.initialWriteConnections must be at least 1.");
        Validator.ensureTrue(maxWriteConnections >= initialWriteConnections, "LDAPReadWriteConnectionPool.initialWriteConnections must not be greater than maxWriteConnections.");
        this.readPool = new LDAPConnectionPool(readConnection, initialReadConnections, maxReadConnections);
        try {
            this.writePool = new LDAPConnectionPool(writeConnection, initialWriteConnections, maxWriteConnections);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.readPool.close();
            throw le;
        }
    }

    public LDAPReadWriteConnectionPool(@NotNull LDAPConnectionPool readPool, @NotNull LDAPConnectionPool writePool) {
        Validator.ensureNotNull(readPool, writePool);
        this.readPool = readPool;
        this.writePool = writePool;
    }

    @Override
    public void close() {
        this.readPool.close();
        this.writePool.close();
    }

    public boolean isClosed() {
        return this.readPool.isClosed() || this.writePool.isClosed();
    }

    @NotNull
    public LDAPConnection getReadConnection() throws LDAPException {
        return this.readPool.getConnection();
    }

    public void releaseReadConnection(@NotNull LDAPConnection connection) {
        this.readPool.releaseConnection(connection);
    }

    public void releaseDefunctReadConnection(@NotNull LDAPConnection connection) {
        this.readPool.releaseDefunctConnection(connection);
    }

    @NotNull
    public LDAPConnection getWriteConnection() throws LDAPException {
        return this.writePool.getConnection();
    }

    public void releaseWriteConnection(@NotNull LDAPConnection connection) {
        this.writePool.releaseConnection(connection);
    }

    public void releaseDefunctWriteConnection(@NotNull LDAPConnection connection) {
        this.writePool.releaseDefunctConnection(connection);
    }

    @NotNull
    public LDAPConnectionPoolStatistics getReadPoolStatistics() {
        return this.readPool.getConnectionPoolStatistics();
    }

    @NotNull
    public LDAPConnectionPoolStatistics getWritePoolStatistics() {
        return this.writePool.getConnectionPoolStatistics();
    }

    @NotNull
    public LDAPConnectionPool getReadPool() {
        return this.readPool;
    }

    @NotNull
    public LDAPConnectionPool getWritePool() {
        return this.writePool;
    }

    @Override
    @Nullable
    public RootDSE getRootDSE() throws LDAPException {
        return this.readPool.getRootDSE();
    }

    @Override
    @Nullable
    public Schema getSchema() throws LDAPException {
        return this.readPool.getSchema();
    }

    @Override
    @Nullable
    public Schema getSchema(@Nullable String entryDN) throws LDAPException {
        return this.readPool.getSchema(entryDN);
    }

    @Override
    @Nullable
    public SearchResultEntry getEntry(@NotNull String dn) throws LDAPException {
        return this.readPool.getEntry(dn);
    }

    @Override
    @Nullable
    public SearchResultEntry getEntry(@NotNull String dn, String ... attributes) throws LDAPException {
        return this.readPool.getEntry(dn, attributes);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull String dn, Attribute ... attributes) throws LDAPException {
        return this.writePool.add(dn, attributes);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull String dn, @NotNull Collection<Attribute> attributes) throws LDAPException {
        return this.writePool.add(dn, attributes);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull Entry entry) throws LDAPException {
        return this.writePool.add(entry);
    }

    @Override
    @NotNull
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.writePool.add(ldifLines);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull AddRequest addRequest) throws LDAPException {
        return this.writePool.add(addRequest);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.writePool.add((AddRequest)addRequest);
    }

    @NotNull
    public BindResult bind(@Nullable String bindDN, @Nullable String password) throws LDAPException {
        return this.readPool.bind(bindDN, password);
    }

    @NotNull
    public BindResult bind(@NotNull BindRequest bindRequest) throws LDAPException {
        return this.readPool.bind(bindRequest);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull String dn, @NotNull String attributeName, @NotNull String assertionValue) throws LDAPException {
        return this.readPool.compare(dn, attributeName, assertionValue);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull CompareRequest compareRequest) throws LDAPException {
        return this.readPool.compare(compareRequest);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.readPool.compare(compareRequest);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull String dn) throws LDAPException {
        return this.writePool.delete(dn);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull DeleteRequest deleteRequest) throws LDAPException {
        return this.writePool.delete(deleteRequest);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.writePool.delete(deleteRequest);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, @NotNull Modification mod) throws LDAPException {
        return this.writePool.modify(dn, mod);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, Modification ... mods) throws LDAPException {
        return this.writePool.modify(dn, mods);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, @NotNull List<Modification> mods) throws LDAPException {
        return this.writePool.modify(dn, mods);
    }

    @Override
    @NotNull
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        return this.writePool.modify(ldifModificationLines);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull ModifyRequest modifyRequest) throws LDAPException {
        return this.writePool.modify(modifyRequest);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.writePool.modify(modifyRequest);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN) throws LDAPException {
        return this.writePool.modifyDN(dn, newRDN, deleteOldRDN);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN, @Nullable String newSuperiorDN) throws LDAPException {
        return this.writePool.modifyDN(dn, newRDN, deleteOldRDN, newSuperiorDN);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull ModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.writePool.modifyDN(modifyDNRequest);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.writePool.modifyDN(modifyDNRequest);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(baseDN, scope, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(baseDN, scope, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(searchResultListener, baseDN, scope, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(searchResultListener, baseDN, scope, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        return this.readPool.search(searchRequest);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.readPool.search(searchRequest);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.searchForEntry(baseDN, scope, filter, attributes);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.searchForEntry(baseDN, scope, filter, attributes);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        return this.readPool.searchForEntry(searchRequest);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.readPool.searchForEntry(searchRequest);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

