/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AllExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AnyExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExceptExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.FieldExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;

public final class ExpressionParser {
    public static RoleMapperExpression readExpression(StreamInput in) throws IOException {
        return (RoleMapperExpression)in.readNamedWriteable(RoleMapperExpression.class);
    }

    public static void writeExpression(RoleMapperExpression expression, StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)expression);
    }

    static List<RoleMapperExpression> readExpressionList(StreamInput in) throws IOException {
        return in.readNamedWriteableCollectionAsList(RoleMapperExpression.class);
    }

    static void writeExpressionList(List<RoleMapperExpression> list, StreamOutput out) throws IOException {
        out.writeNamedWriteableCollection(list);
    }

    public static RoleMapperExpression parseObject(XContentParser parser, String id) throws IOException {
        return new ExpressionParser().parse(id, parser);
    }

    public RoleMapperExpression parse(String name, XContentSource content) throws IOException {
        try (StreamInput stream = content.getBytes().streamInput();){
            RoleMapperExpression roleMapperExpression = this.parse(name, content.parser(NamedXContentRegistry.EMPTY, (InputStream)stream));
            return roleMapperExpression;
        }
    }

    public RoleMapperExpression parse(String name, XContentParser parser) throws IOException {
        return this.parseRulesObject(name, parser, false);
    }

    private RoleMapperExpression parseRulesObject(String objectName, XContentParser parser, boolean allowExcept) throws IOException {
        XContentParser.Token token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. expected [{}] to be an object but found [{}] instead", new Object[]{objectName, token});
        }
        String fieldName = ExpressionParser.readFieldName(objectName, parser);
        RoleMapperExpression expr = this.parseExpression(parser, fieldName, allowExcept, objectName);
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] contains multiple fields", new Object[]{objectName});
        }
        return expr;
    }

    private RoleMapperExpression parseExpression(XContentParser parser, String field, boolean allowExcept, String objectName) throws IOException {
        if (Fields.ANY.match(field, parser.getDeprecationHandler())) {
            return new AnyExpression(this.parseExpressionArray(Fields.ANY, parser, false));
        }
        if (Fields.ALL.match(field, parser.getDeprecationHandler())) {
            return new AllExpression(this.parseExpressionArray(Fields.ALL, parser, true));
        }
        if (Fields.FIELD.match(field, parser.getDeprecationHandler())) {
            return ExpressionParser.parseFieldExpression(parser);
        }
        if (Fields.EXCEPT.match(field, parser.getDeprecationHandler())) {
            if (allowExcept) {
                return this.parseExceptExpression(parser);
            }
            throw new ElasticsearchParseException("failed to parse rules expression. field [{}] is not allowed within [{}]", new Object[]{field, objectName});
        }
        throw new ElasticsearchParseException("failed to parse rules expression. field [{}] is not recognised in object [{}]", new Object[]{field, objectName});
    }

    private static RoleMapperExpression parseFieldExpression(XContentParser parser) throws IOException {
        ExpressionParser.checkStartObject(parser);
        String fieldName = ExpressionParser.readFieldName(Fields.FIELD.getPreferredName(), parser);
        List<FieldExpression.FieldValue> values = parser.nextToken() == XContentParser.Token.START_ARRAY ? ExpressionParser.parseArray(Fields.FIELD, parser, ExpressionParser::parseFieldValue) : Collections.singletonList(ExpressionParser.parseFieldValue(parser));
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] contains multiple fields", new Object[]{Fields.FIELD.getPreferredName()});
        }
        return new FieldExpression(fieldName, values);
    }

    private RoleMapperExpression parseExceptExpression(XContentParser parser) throws IOException {
        ExpressionParser.checkStartObject(parser);
        return new ExceptExpression(this.parseRulesObject(Fields.EXCEPT.getPreferredName(), parser, false));
    }

    private static void checkStartObject(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. expected an object but found [{}] instead", new Object[]{token});
        }
    }

    private static String readFieldName(String objectName, XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] does not contain any fields", new Object[]{objectName});
        }
        return parser.currentName();
    }

    private List<RoleMapperExpression> parseExpressionArray(ParseField field, XContentParser parser, boolean allowExcept) throws IOException {
        parser.nextToken();
        return ExpressionParser.parseArray(field, parser, p -> this.parseRulesObject(field.getPreferredName(), (XContentParser)p, allowExcept));
    }

    private static <T> List<T> parseArray(ParseField field, XContentParser parser, CheckedFunction<XContentParser, T, IOException> elementParser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                list.add(elementParser.apply((Object)parser));
            }
            return list;
        }
        throw new ElasticsearchParseException("failed to parse rules expression. field [{}] requires an array", new Object[]{field});
    }

    private static FieldExpression.FieldValue parseFieldValue(XContentParser parser) throws IOException {
        return switch (parser.currentToken()) {
            case XContentParser.Token.VALUE_STRING -> new FieldExpression.FieldValue(parser.text());
            case XContentParser.Token.VALUE_BOOLEAN -> new FieldExpression.FieldValue(parser.booleanValue());
            case XContentParser.Token.VALUE_NUMBER -> new FieldExpression.FieldValue(parser.longValue());
            case XContentParser.Token.VALUE_NULL -> new FieldExpression.FieldValue(null);
            default -> throw new ElasticsearchParseException("failed to parse rules expression. expected a field value but found [{}] instead", new Object[]{parser.currentToken()});
        };
    }

    public static interface Fields {
        public static final ParseField ANY = new ParseField("any", new String[0]);
        public static final ParseField ALL = new ParseField("all", new String[0]);
        public static final ParseField EXCEPT = new ParseField("except", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
    }
}

