/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.FieldExpression;

public class ExpressionModel {
    public static final Predicate<FieldExpression.FieldValue> NULL_PREDICATE = field -> field.getValue() == null;
    private static final Logger logger = LogManager.getLogger(ExpressionModel.class);
    private final Map<String, Object> fieldValues = new HashMap<String, Object>();
    private final Map<String, Predicate<FieldExpression.FieldValue>> fieldPredicates = new HashMap<String, Predicate<FieldExpression.FieldValue>>();

    public ExpressionModel defineField(String name, Object value) {
        return this.defineField(name, value, ExpressionModel.buildPredicate(value));
    }

    public ExpressionModel defineField(String name, Object value, Predicate<FieldExpression.FieldValue> predicate) {
        this.fieldValues.put(name, value);
        this.fieldPredicates.put(name, predicate);
        return this;
    }

    public boolean test(String field, List<FieldExpression.FieldValue> values) {
        Predicate<FieldExpression.FieldValue> predicate = this.fieldPredicates.getOrDefault(field, NULL_PREDICATE);
        boolean isMatch = values.stream().anyMatch(predicate);
        if (!isMatch && predicate == NULL_PREDICATE && !this.fieldPredicates.containsKey(field)) {
            logger.debug(() -> Strings.format((String)"Attempt to test field [%s] against value(s) [%s], but the field [%s] does not have a value on this object; known fields are [%s]", (Object[])new Object[]{field, org.elasticsearch.common.Strings.collectionToCommaDelimitedString((Iterable)values), field, org.elasticsearch.common.Strings.collectionToCommaDelimitedString(this.fieldPredicates.keySet())}));
        }
        return isMatch;
    }

    static Predicate<FieldExpression.FieldValue> buildPredicate(Object object) {
        if (object == null) {
            return NULL_PREDICATE;
        }
        if (object instanceof Boolean) {
            return field -> object.equals(field.getValue());
        }
        if (object instanceof Number) {
            return field -> ExpressionModel.numberEquals((Number)object, field.getValue());
        }
        if (object instanceof String) {
            return field -> field.getAutomaton() == null ? object.equals(field.getValue()) : field.getAutomaton().run((String)object);
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(element -> ExpressionModel.buildPredicate(element)).reduce((a, b) -> a.or(b)).orElse(fieldValue -> false);
        }
        throw new IllegalArgumentException("Unsupported value type " + object.getClass());
    }

    private static boolean numberEquals(Number left, Object other) {
        if (left.equals(other)) {
            return true;
        }
        if (!(other instanceof Number)) {
            return false;
        }
        Number right = (Number)other;
        if (left instanceof Double || left instanceof Float || right instanceof Double || right instanceof Float) {
            return Double.compare(left.doubleValue(), right.doubleValue()) == 0;
        }
        return Numbers.toLongExact((Number)left) == Numbers.toLongExact((Number)right);
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.fieldValues);
    }

    public String toString() {
        return this.fieldValues.toString();
    }
}

