/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.token;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public final class CreateTokenResponse
extends ActionResponse
implements ToXContentObject {
    private String tokenString;
    private TimeValue expiresIn;
    private String scope;
    private String refreshToken;
    private String kerberosAuthenticationResponseToken;
    private Authentication authentication;

    CreateTokenResponse() {
    }

    public CreateTokenResponse(StreamInput in) throws IOException {
        super(in);
        this.tokenString = in.readString();
        this.expiresIn = in.readTimeValue();
        this.scope = in.readOptionalString();
        this.refreshToken = in.readOptionalString();
        this.kerberosAuthenticationResponseToken = in.readOptionalString();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_11_0)) {
            this.authentication = new Authentication(in);
        }
    }

    public CreateTokenResponse(String tokenString, TimeValue expiresIn, String scope, String refreshToken, String kerberosAuthenticationResponseToken, Authentication authentication) {
        this.tokenString = Objects.requireNonNull(tokenString);
        this.expiresIn = Objects.requireNonNull(expiresIn);
        this.scope = scope;
        this.refreshToken = refreshToken;
        this.kerberosAuthenticationResponseToken = kerberosAuthenticationResponseToken;
        this.authentication = authentication;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getScope() {
        return this.scope;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getKerberosAuthenticationResponseToken() {
        return this.kerberosAuthenticationResponseToken;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.tokenString);
        out.writeTimeValue(this.expiresIn);
        out.writeOptionalString(this.scope);
        out.writeOptionalString(this.refreshToken);
        out.writeOptionalString(this.kerberosAuthenticationResponseToken);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_11_0)) {
            this.authentication.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("access_token", this.tokenString).field("type", "Bearer").field("expires_in", this.expiresIn.seconds());
        if (this.refreshToken != null) {
            builder.field("refresh_token", this.refreshToken);
        }
        if (this.scope != null) {
            builder.field("scope", this.scope);
        }
        if (this.kerberosAuthenticationResponseToken != null) {
            builder.field("kerberos_authentication_response_token", this.kerberosAuthenticationResponseToken);
        }
        if (this.authentication != null) {
            builder.field("authentication", (ToXContent)this.authentication);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateTokenResponse that = (CreateTokenResponse)((Object)o);
        return Objects.equals(this.tokenString, that.tokenString) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.scope, that.scope) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.kerberosAuthenticationResponseToken, that.kerberosAuthenticationResponseToken) && Objects.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return Objects.hash(this.tokenString, this.expiresIn, this.scope, this.refreshToken, this.kerberosAuthenticationResponseToken, this.authentication);
    }
}

