/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.XContentObjectTransformer;

public class QueryProvider
implements Writeable,
ToXContentObject,
Rewriteable<QueryProvider> {
    private static final Logger logger = LogManager.getLogger(QueryProvider.class);
    private final Exception parsingException;
    private final QueryBuilder parsedQuery;
    private final Map<String, Object> query;

    public static QueryProvider defaultQuery() {
        return new QueryProvider(Collections.singletonMap("match_all", Collections.emptyMap()), (QueryBuilder)QueryBuilders.matchAllQuery(), null);
    }

    public static QueryProvider fromXContent(XContentParser parser, boolean lenient, String failureMessage) throws IOException {
        Map query = parser.mapOrdered();
        QueryBuilder parsedQuery = null;
        Exception exception = null;
        try {
            parsedQuery = XContentObjectTransformer.queryBuilderTransformer(parser.getXContentRegistry()).fromMap(query);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                ex = (Exception)ex.getCause();
            }
            exception = ex;
            if (lenient) {
                logger.warn(failureMessage, (Throwable)ex);
            }
            throw ExceptionsHelper.badRequestException(failureMessage, ex, new Object[0]);
        }
        return new QueryProvider(query, parsedQuery, exception);
    }

    public static QueryProvider fromParsedQuery(QueryBuilder parsedQuery) throws IOException {
        return parsedQuery == null ? null : new QueryProvider(XContentObjectTransformer.queryBuilderTransformer(NamedXContentRegistry.EMPTY).toMap(parsedQuery), parsedQuery, null);
    }

    public static QueryProvider fromStream(StreamInput in) throws IOException {
        return new QueryProvider(in.readMap(), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class), in.readException());
    }

    QueryProvider(Map<String, Object> query, QueryBuilder parsedQuery, Exception parsingException) {
        this.query = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(Objects.requireNonNull(query, "[query] must not be null")));
        this.parsedQuery = parsedQuery;
        this.parsingException = parsingException;
    }

    public QueryProvider(QueryProvider other) {
        this(other.query, other.parsedQuery, other.parsingException);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericMap(this.query);
        out.writeOptionalNamedWriteable((NamedWriteable)this.parsedQuery);
        out.writeException((Throwable)this.parsingException);
    }

    public Exception getParsingException() {
        return this.parsingException;
    }

    public QueryBuilder getParsedQuery() {
        return this.parsedQuery;
    }

    public Map<String, Object> getQuery() {
        return this.query;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryProvider that = (QueryProvider)other;
        return Objects.equals(this.query, that.query) && Objects.equals(this.parsedQuery, that.parsedQuery) && Objects.equals(this.parsingException, that.parsingException);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.parsedQuery, this.parsingException);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.map(this.query);
        return builder;
    }

    public QueryProvider rewrite(QueryRewriteContext ctx) throws IOException {
        assert (this.parsedQuery != null);
        if (this.parsedQuery == null) {
            return this;
        }
        QueryBuilder rewritten = (QueryBuilder)Rewriteable.rewrite((Rewriteable)this.parsedQuery, (QueryRewriteContext)ctx);
        if (rewritten == this.parsedQuery) {
            return this;
        }
        return new QueryProvider(this.query, rewritten, this.parsingException);
    }
}

