/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr.LearningToRankFeatureExtractorBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.QueryProvider;

public record QueryExtractorBuilder(String featureName, QueryProvider query, float defaultScore) implements LearningToRankFeatureExtractorBuilder
{
    public static final ParseField NAME = new ParseField("query_extractor", new String[0]);
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField DEFAULT_SCORE = new ParseField("default_score", new String[0]);
    public static float DEFAULT_SCORE_DEFAULT = 0.0f;
    private static final ConstructingObjectParser<QueryExtractorBuilder, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new QueryExtractorBuilder((String)a[0], (QueryProvider)a[1], Objects.requireNonNullElse((Float)a[2], Float.valueOf(DEFAULT_SCORE_DEFAULT)).floatValue()));
    private static final ConstructingObjectParser<QueryExtractorBuilder, Void> LENIENT_PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new QueryExtractorBuilder((String)a[0], (QueryProvider)a[1], Objects.requireNonNullElse((Float)a[2], Float.valueOf(DEFAULT_SCORE_DEFAULT)).floatValue()));

    public QueryExtractorBuilder(String featureName, QueryProvider query) {
        this(featureName, query, DEFAULT_SCORE_DEFAULT);
    }

    public QueryExtractorBuilder(String featureName, QueryProvider query, float defaultScore) {
        this.featureName = ExceptionsHelper.requireNonNull(featureName, FEATURE_NAME);
        this.query = ExceptionsHelper.requireNonNull(query, QUERY);
        if (defaultScore < 0.0f) {
            throw new IllegalArgumentException("[" + NAME + "] requires defaultScore to be positive.");
        }
        this.defaultScore = defaultScore;
    }

    public QueryExtractorBuilder(StreamInput input) throws IOException {
        this(input.readString(), QueryProvider.fromStream(input), input.readFloat());
    }

    public static QueryExtractorBuilder fromXContent(XContentParser parser, Object context) {
        boolean lenient = Boolean.TRUE.equals(context);
        return lenient ? (QueryExtractorBuilder)LENIENT_PARSER.apply(parser, null) : (QueryExtractorBuilder)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FEATURE_NAME.getPreferredName(), this.featureName);
        if (this.defaultScore > 0.0f) {
            builder.field(DEFAULT_SCORE.getPreferredName(), this.defaultScore);
        }
        builder.field(QUERY.getPreferredName(), this.query.getQuery());
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        this.query.writeTo(out);
        out.writeFloat(this.defaultScore);
    }

    @Override
    public void validate() throws Exception {
        if (this.query.getParsingException() != null) {
            throw this.query.getParsingException();
        }
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public QueryExtractorBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        QueryProvider rewritten = (QueryProvider)Rewriteable.rewrite((Rewriteable)this.query, (QueryRewriteContext)ctx);
        if (rewritten == this.query) {
            return this;
        }
        return new QueryExtractorBuilder(this.featureName, rewritten, this.defaultScore);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> QueryProvider.fromXContent(p, false, "Inference config query is not parsable"), QUERY);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), DEFAULT_SCORE);
        LENIENT_PARSER.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> QueryProvider.fromXContent(p, true, "Inference config query is not parsable"), QUERY);
        LENIENT_PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), DEFAULT_SCORE);
    }
}

