/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;

public class RobertaTokenization
extends Tokenization {
    public static final String NAME = "roberta";
    public static final String MASK_TOKEN = "<mask>";
    private static final boolean DEFAULT_ADD_PREFIX_SPACE = false;
    private static final ParseField ADD_PREFIX_SPACE = new ParseField("add_prefix_space", new String[0]);
    private static final ConstructingObjectParser<RobertaTokenization, Void> LENIENT_PARSER = RobertaTokenization.createParser(true);
    private static final ConstructingObjectParser<RobertaTokenization, Void> STRICT_PARSER = RobertaTokenization.createParser(false);
    private final boolean addPrefixSpace;

    public static ConstructingObjectParser<RobertaTokenization, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("roberta_tokenization", ignoreUnknownFields, a -> new RobertaTokenization((Boolean)a[0], (Boolean)a[1], (Integer)a[2], a[3] == null ? null : Tokenization.Truncate.fromString((String)a[3]), (Integer)a[4], (Boolean)a[5]));
        RobertaTokenization.declareCommonFields(parser);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ADD_PREFIX_SPACE);
        return parser;
    }

    public static RobertaTokenization fromXContent(XContentParser parser, boolean lenient) {
        return lenient ? (RobertaTokenization)LENIENT_PARSER.apply(parser, null) : (RobertaTokenization)STRICT_PARSER.apply(parser, null);
    }

    private RobertaTokenization(@Nullable Boolean doLowerCase, @Nullable Boolean withSpecialTokens, @Nullable Integer maxSequenceLength, @Nullable Tokenization.Truncate truncate, @Nullable Integer span, @Nullable Boolean addPrefixSpace) {
        this(withSpecialTokens, addPrefixSpace, maxSequenceLength, truncate, span);
        if (doLowerCase != null && doLowerCase.booleanValue()) {
            throw new IllegalArgumentException("unable to set [do_lower_case] to [true] for roberta tokenizer");
        }
    }

    public RobertaTokenization(@Nullable Boolean withSpecialTokens, @Nullable Boolean addPrefixSpace, @Nullable Integer maxSequenceLength, @Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        super(false, withSpecialTokens, maxSequenceLength, truncate, span);
        this.addPrefixSpace = Optional.ofNullable(addPrefixSpace).orElse(false);
    }

    public RobertaTokenization(StreamInput in) throws IOException {
        super(in);
        this.addPrefixSpace = in.readBoolean();
    }

    public boolean isAddPrefixSpace() {
        return this.addPrefixSpace;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.addPrefixSpace);
    }

    @Override
    public String getMaskToken() {
        return MASK_TOKEN;
    }

    @Override
    XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ADD_PREFIX_SPACE.getPreferredName(), this.addPrefixSpace);
        return builder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void validateVocabulary(PutTrainedModelVocabularyAction.Request request) {
        if (request.getMerges().isEmpty()) {
            throw new ElasticsearchStatusException("cannot put vocabulary for model [{}] as tokenizer type [{}] requires [{}] to be provided and non-empty", RestStatus.BAD_REQUEST, new Object[]{request.getModelId(), this.getName(), PutTrainedModelVocabularyAction.Request.MERGES.getPreferredName()});
        }
    }
}

