/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PreviewDatafeedAction
extends ActionType<Response> {
    public static final PreviewDatafeedAction INSTANCE = new PreviewDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeeds/preview";

    private PreviewDatafeedAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final BytesReference preview;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.preview = in.readBytesReference();
        }

        public Response(BytesReference preview) {
            this.preview = preview;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.preview);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            try (StreamInput stream = this.preview.streamInput();){
                builder.rawValue((InputStream)stream, XContentType.JSON);
            }
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.preview);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.preview, other.preview);
        }

        public final String toString() {
            return org.elasticsearch.common.Strings.toString((ToXContent)this);
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private static final String BLANK_ID = "";
        public static final ParseField DATAFEED_CONFIG = new ParseField("datafeed_config", new String[0]);
        public static final ParseField JOB_CONFIG = new ParseField("job_config", new String[0]);
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("preview_datafeed_action", Builder::new);
        private final String datafeedId;
        private final DatafeedConfig datafeedConfig;
        private final Job.Builder jobConfig;
        private final Long startTime;
        private final Long endTime;

        public static Builder fromXContent(XContentParser parser, @Nullable String datafeedId) {
            Builder builder = (Builder)PARSER.apply(parser, null);
            if (datafeedId != null) {
                builder.setDatafeedId(datafeedId);
            }
            return builder;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeedId = in.readString();
            this.datafeedConfig = (DatafeedConfig)in.readOptionalWriteable(DatafeedConfig::new);
            this.jobConfig = (Job.Builder)in.readOptionalWriteable(Job.Builder::new);
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_3_0)) {
                this.startTime = in.readOptionalLong();
                this.endTime = in.readOptionalLong();
            } else {
                this.startTime = null;
                this.endTime = null;
            }
        }

        public Request(String datafeedId, String start, String end) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID);
            this.datafeedConfig = null;
            this.jobConfig = null;
            this.startTime = start == null ? null : Long.valueOf(StartDatafeedAction.DatafeedParams.parseDateOrThrow(start, StartDatafeedAction.START_TIME, System::currentTimeMillis));
            this.endTime = end == null ? null : Long.valueOf(StartDatafeedAction.DatafeedParams.parseDateOrThrow(end, StartDatafeedAction.END_TIME, System::currentTimeMillis));
        }

        Request(String datafeedId, Long start, Long end) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID);
            this.datafeedConfig = null;
            this.jobConfig = null;
            this.startTime = start;
            this.endTime = end;
        }

        public Request(DatafeedConfig datafeedConfig, Job.Builder jobConfig, Long start, Long end) {
            this.datafeedId = BLANK_ID;
            this.datafeedConfig = ExceptionsHelper.requireNonNull(datafeedConfig, DATAFEED_CONFIG.getPreferredName());
            this.jobConfig = jobConfig;
            this.startTime = start;
            this.endTime = end;
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public DatafeedConfig getDatafeedConfig() {
            return this.datafeedConfig;
        }

        public Job.Builder getJobConfig() {
            return this.jobConfig;
        }

        public OptionalLong getStartTime() {
            return this.startTime == null ? OptionalLong.empty() : OptionalLong.of(this.startTime);
        }

        public OptionalLong getEndTime() {
            return this.endTime == null ? OptionalLong.empty() : OptionalLong.of(this.endTime);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            if (this.endTime != null && this.startTime != null && this.endTime <= this.startTime) {
                e = ValidateActions.addValidationError((String)(StartDatafeedAction.START_TIME.getPreferredName() + " [" + this.startTime + "] must be earlier than " + StartDatafeedAction.END_TIME.getPreferredName() + " [" + this.endTime + "]"), e);
            }
            return e;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
            out.writeOptionalWriteable((Writeable)this.datafeedConfig);
            out.writeOptionalWriteable((Writeable)this.jobConfig);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_3_0)) {
                out.writeOptionalLong(this.startTime);
                out.writeOptionalLong(this.endTime);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (!this.datafeedId.equals(BLANK_ID)) {
                builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            }
            if (this.datafeedConfig != null) {
                builder.field(DATAFEED_CONFIG.getPreferredName(), (ToXContent)this.datafeedConfig);
            }
            if (this.jobConfig != null) {
                builder.field(JOB_CONFIG.getPreferredName(), (Object)this.jobConfig);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.datafeedConfig, this.jobConfig);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.datafeedConfig, other.datafeedConfig) && Objects.equals(this.jobConfig, other.jobConfig);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format((String)"preview_datafeed[%s]", (Object[])new Object[]{this.datafeedId}), parentTaskId, headers);
        }

        static {
            PARSER.declareObject(Builder::setDatafeedBuilder, DatafeedConfig.STRICT_PARSER, DATAFEED_CONFIG);
            PARSER.declareObject(Builder::setJobBuilder, Job.STRICT_PARSER, JOB_CONFIG);
            PARSER.declareString(Builder::setStart, StartDatafeedAction.START_TIME);
            PARSER.declareString(Builder::setEnd, StartDatafeedAction.END_TIME);
        }

        public static class Builder {
            private String datafeedId;
            private DatafeedConfig.Builder datafeedBuilder;
            private Job.Builder jobBuilder;
            private Long startTime;
            private Long endTime;

            public Builder setDatafeedId(String datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            public Builder setDatafeedBuilder(DatafeedConfig.Builder datafeedBuilder) {
                this.datafeedBuilder = datafeedBuilder;
                return this;
            }

            public Builder setJobBuilder(Job.Builder jobBuilder) {
                this.jobBuilder = jobBuilder;
                return this;
            }

            public Builder setStart(String startTime) {
                if (startTime == null) {
                    return this;
                }
                return this.setStart(StartDatafeedAction.DatafeedParams.parseDateOrThrow(startTime, StartDatafeedAction.START_TIME, System::currentTimeMillis));
            }

            public Builder setStart(long start) {
                this.startTime = start;
                return this;
            }

            public Builder setEnd(String endTime) {
                if (endTime == null) {
                    return this;
                }
                return this.setEnd(StartDatafeedAction.DatafeedParams.parseDateOrThrow(endTime, StartDatafeedAction.END_TIME, System::currentTimeMillis));
            }

            public Builder setEnd(long end) {
                this.endTime = end;
                return this;
            }

            public Request build() {
                if (this.datafeedBuilder != null) {
                    this.datafeedBuilder.setId("preview_id");
                    if (this.datafeedBuilder.getJobId() == null && this.jobBuilder == null) {
                        throw new IllegalArgumentException("[datafeed_config.job_id] must be set or a [job_config] must be provided");
                    }
                    if (this.datafeedBuilder.getJobId() == null) {
                        this.datafeedBuilder.setJobId("preview_job_id");
                    }
                }
                if (this.jobBuilder != null) {
                    this.jobBuilder.setId("preview_job_id");
                    if (this.datafeedBuilder == null && this.jobBuilder.getDatafeedConfig() == null) {
                        throw new IllegalArgumentException("[datafeed_config] must be present when a [job_config.datafeed_config] is not present");
                    }
                    if (this.datafeedBuilder != null && this.jobBuilder.getDatafeedConfig() != null) {
                        throw new IllegalArgumentException("[datafeed_config] must not be present when a [job_config.datafeed_config] is present");
                    }
                    if (this.jobBuilder.getDatafeedConfig() != null) {
                        this.datafeedBuilder = this.jobBuilder.getDatafeedConfig().setJobId(this.jobBuilder.getId()).setId(this.jobBuilder.getId());
                    }
                }
                if (this.datafeedId != null && (this.datafeedBuilder != null || this.jobBuilder != null)) {
                    throw new IllegalArgumentException("[datafeed_id] cannot be supplied when either [job_config] or [datafeed_config] is present");
                }
                return this.datafeedId != null ? new Request(this.datafeedId, this.startTime, this.endTime) : new Request(this.datafeedBuilder == null ? null : this.datafeedBuilder.build(), this.jobBuilder, this.startTime, this.endTime);
            }
        }
    }
}

