/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;

public record SparseEmbeddingResults(List<Embedding> embeddings) implements InferenceServiceResults
{
    public static final String NAME = "sparse_embedding_results";
    public static final String SPARSE_EMBEDDING = TaskType.SPARSE_EMBEDDING.toString();

    public SparseEmbeddingResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Embedding::new));
    }

    public static SparseEmbeddingResults of(List<? extends InferenceResults> results) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>(results.size());
        for (InferenceResults inferenceResults : results) {
            if (inferenceResults instanceof TextExpansionResults) {
                TextExpansionResults expansionResults = (TextExpansionResults)inferenceResults;
                embeddings.add(Embedding.create(expansionResults.getWeightedTokens(), expansionResults.isTruncated()));
                continue;
            }
            throw new IllegalArgumentException("Received invalid legacy inference result");
        }
        return new SparseEmbeddingResults(embeddings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(SPARSE_EMBEDDING);
        for (Embedding embedding : this.embeddings) {
            embedding.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List<Map> embeddingList = this.embeddings.stream().map(Embedding::asMap).toList();
        map.put(SPARSE_EMBEDDING, embeddingList);
        return map;
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.transformToLegacyFormat();
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        return this.embeddings.stream().map(embedding -> new TextExpansionResults("predicted_value", embedding.tokens().stream().map(weightedToken -> new TextExpansionResults.WeightedToken(weightedToken.token, weightedToken.weight)).toList(), embedding.isTruncated)).toList();
    }

    public record Embedding(List<WeightedToken> tokens, boolean isTruncated) implements Writeable,
    ToXContentObject
    {
        public static final String EMBEDDING = "embedding";
        public static final String IS_TRUNCATED = "is_truncated";

        public Embedding(StreamInput in) throws IOException {
            this(in.readCollectionAsList(WeightedToken::new), in.readBoolean());
        }

        public static Embedding create(List<TextExpansionResults.WeightedToken> weightedTokens, boolean isTruncated) {
            return new Embedding(weightedTokens.stream().map(token -> new WeightedToken(token.token(), token.weight())).toList(), isTruncated);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.tokens);
            out.writeBoolean(this.isTruncated);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(IS_TRUNCATED, this.isTruncated);
            builder.startObject(EMBEDDING);
            for (WeightedToken weightedToken : this.tokens) {
                weightedToken.toXContent(builder, params);
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Float> embeddingMap = new LinkedHashMap<String, Float>(this.tokens.stream().collect(Collectors.toMap(WeightedToken::token, WeightedToken::weight)));
            return new LinkedHashMap<String, Object>(Map.of(IS_TRUNCATED, this.isTruncated, EMBEDDING, embeddingMap));
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public record WeightedToken(String token, float weight) implements Writeable,
    ToXContentFragment
    {
        public WeightedToken(StreamInput in) throws IOException {
            this(in.readString(), in.readFloat());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.token);
            out.writeFloat(this.weight);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.token, this.weight);
            return builder;
        }

        public Map<String, Object> asMap() {
            return Map.of(this.token, Float.valueOf(this.weight));
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

