/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class InferenceFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final Collection<ModelStats> modelStats;

    public InferenceFeatureSetUsage(Collection<ModelStats> modelStats) {
        super("inference", true, true);
        this.modelStats = modelStats;
    }

    public InferenceFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.modelStats = in.readCollectionAsList(ModelStats::new);
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.xContentList("models", this.modelStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.modelStats);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.INFERENCE_USAGE_ADDED;
    }

    public static class ModelStats
    implements ToXContentObject,
    Writeable {
        private final String service;
        private final TaskType taskType;
        private long count;

        public ModelStats(String service, TaskType taskType) {
            this(service, taskType, 0L);
        }

        public ModelStats(String service, TaskType taskType, long count) {
            this.service = service;
            this.taskType = taskType;
            this.count = count;
        }

        public ModelStats(ModelStats stats) {
            this(stats.service, stats.taskType, stats.count);
        }

        public ModelStats(StreamInput in) throws IOException {
            this.service = in.readString();
            this.taskType = (TaskType)in.readEnum(TaskType.class);
            this.count = in.readLong();
        }

        public void add() {
            ++this.count;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("service", this.service);
            builder.field("task_type", this.taskType.name());
            builder.field("count", this.count);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.service);
            out.writeEnum((Enum)this.taskType);
            out.writeLong(this.count);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelStats that = (ModelStats)o;
            return this.count == that.count && Objects.equals(this.service, that.service) && this.taskType == that.taskType;
        }

        public int hashCode() {
            return Objects.hash(this.service, this.taskType, this.count);
        }
    }
}

