/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.tracing;

import java.util.Map;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.telemetry.tracing.SpanId;

public interface Tracer {
    public static final Tracer NOOP = new Tracer(){

        @Override
        public void startTrace(ThreadContext threadContext, SpanId spanId, String name, Map<String, Object> attributes) {
        }

        @Override
        public void startTrace(ThreadContext threadContext, Task task, String name, Map<String, Object> attributes) {
        }

        @Override
        public void startTrace(ThreadContext threadContext, RestRequest restRequest, String name, Map<String, Object> attributes) {
        }

        @Override
        public void startTrace(String name, Map<String, Object> attributes) {
        }

        @Override
        public void stopTrace(SpanId spanId) {
        }

        @Override
        public void stopTrace(Task task) {
        }

        @Override
        public void stopTrace(RestRequest restRequest) {
        }

        @Override
        public void stopTrace() {
        }

        @Override
        public void addEvent(SpanId spanId, String eventName) {
        }

        @Override
        public void addError(SpanId spanId, Throwable throwable) {
        }

        @Override
        public void addError(RestRequest restRequest, Throwable throwable) {
        }

        @Override
        public void setAttribute(SpanId spanId, String key, boolean value) {
        }

        @Override
        public void setAttribute(SpanId spanId, String key, double value) {
        }

        @Override
        public void setAttribute(SpanId spanId, String key, long value) {
        }

        @Override
        public void setAttribute(SpanId spanId, String key, String value) {
        }

        @Override
        public Releasable withScope(SpanId spanId) {
            return () -> {};
        }
    };

    public void startTrace(ThreadContext var1, SpanId var2, String var3, Map<String, Object> var4);

    default public void startTrace(ThreadContext threadContext, Task task, String name, Map<String, Object> attributes) {
        this.startTrace(threadContext, SpanId.forTask(task), name, attributes);
    }

    default public void startTrace(ThreadContext threadContext, RestRequest restRequest, String name, Map<String, Object> attributes) {
        this.startTrace(threadContext, SpanId.forRestRequest(restRequest), name, attributes);
    }

    public void startTrace(String var1, Map<String, Object> var2);

    public void stopTrace(SpanId var1);

    default public void stopTrace(Task task) {
        this.stopTrace(SpanId.forTask(task));
    }

    default public void stopTrace(RestRequest restRequest) {
        this.stopTrace(SpanId.forRestRequest(restRequest));
    }

    public void stopTrace();

    public void addEvent(SpanId var1, String var2);

    public void addError(SpanId var1, Throwable var2);

    default public void addError(RestRequest restRequest, Throwable throwable) {
        this.addError(SpanId.forRestRequest(restRequest), throwable);
    }

    public void setAttribute(SpanId var1, String var2, boolean var3);

    public void setAttribute(SpanId var1, String var2, double var3);

    public void setAttribute(SpanId var1, String var2, long var3);

    public void setAttribute(SpanId var1, String var2, String var3);

    public Releasable withScope(SpanId var1);

    public static interface AttributeKeys {
        public static final String TASK_ID = "es.task.id";
        public static final String PARENT_TASK_ID = "es.task.parent.id";
        public static final String CLUSTER_NAME = "es.cluster.name";
        public static final String NODE_NAME = "es.node.name";
    }
}

