/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class PhraseSuggestion
extends Suggest.Suggestion<Entry> {
    public PhraseSuggestion(String name, int size) {
        super(name, size);
    }

    public PhraseSuggestion(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "phrase";
    }

    @Override
    protected Entry newEntry(StreamInput in) throws IOException {
        return new Entry(in);
    }

    public static PhraseSuggestion fromXContent(XContentParser parser, String name) throws IOException {
        PhraseSuggestion suggestion = new PhraseSuggestion(name, -1);
        PhraseSuggestion.parseEntries(parser, suggestion, Entry::fromXContent);
        return suggestion;
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Option> {
        protected double cutoffScore = Double.MIN_VALUE;
        private static final ObjectParser<Entry, Void> PARSER = new ObjectParser("PhraseSuggestionEntryParser", true, Entry::new);

        public Entry(Text text, int offset, int length, double cutoffScore) {
            super(text, offset, length);
            this.cutoffScore = cutoffScore;
        }

        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        Entry() {
        }

        public Entry(StreamInput in) throws IOException {
            super(in);
            this.cutoffScore = in.readDouble();
        }

        @Override
        protected void merge(Suggest.Suggestion.Entry<Option> other) {
            super.merge(other);
            if (!(other instanceof Entry)) {
                return;
            }
            Entry otherSuggestionEntry = (Entry)other;
            this.cutoffScore = Math.max(this.cutoffScore, otherSuggestionEntry.cutoffScore);
        }

        @Override
        public void addOption(Option option) {
            if ((double)option.getScore() > this.cutoffScore) {
                this.options.add(option);
            }
        }

        public static Entry fromXContent(XContentParser parser) {
            return (Entry)PARSER.apply(parser, null);
        }

        @Override
        protected Option newOption(StreamInput in) throws IOException {
            return new Option(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeDouble(this.cutoffScore);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && Objects.equals(this.cutoffScore, ((Entry)other).cutoffScore);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.cutoffScore);
        }

        static {
            Entry.declareCommonFields(PARSER);
            PARSER.declareObjectArray((e, o) -> e.addOptions(o), (p, c) -> Option.fromXContent(p), new ParseField("options", new String[0]));
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            private static final ConstructingObjectParser<Option, Void> PARSER = new ConstructingObjectParser("PhraseOptionParser", true, args -> {
                Text text = new Text((String)args[0]);
                float score = ((Float)args[1]).floatValue();
                String highlighted = (String)args[2];
                Text highlightedText = highlighted == null ? null : new Text(highlighted);
                Boolean collateMatch = (Boolean)args[3];
                return new Option(text, highlightedText, score, collateMatch);
            });

            public Option(Text text, Text highlighted, float score, Boolean collateMatch) {
                super(text, highlighted, score, collateMatch);
            }

            public Option(Text text, Text highlighted, float score) {
                super(text, highlighted, score);
            }

            public Option(StreamInput in) throws IOException {
                super(in);
            }

            public static Option fromXContent(XContentParser parser) {
                return (Option)PARSER.apply(parser, null);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), TEXT);
                PARSER.declareFloat(ConstructingObjectParser.constructorArg(), SCORE);
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), HIGHLIGHTED);
                PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), COLLATE_MATCH);
            }
        }
    }
}

