/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.field.vectors.DenseVector;
import org.elasticsearch.script.field.vectors.DenseVectorDocValuesField;

public class VectorScoreScriptUtils {

    public static final class CosineSimilarity {
        private final CosineSimilarityInterface function;

        public CosineSimilarity(ScoreScript scoreScript, List<Number> queryVector, String fieldName) {
            DenseVectorDocValuesField field = (DenseVectorDocValuesField)scoreScript.field(fieldName);
            this.function = switch (field.getElementType()) {
                default -> throw new IncompatibleClassChangeError();
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteCosineSimilarity(scoreScript, field, queryVector);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatCosineSimilarity(scoreScript, field, queryVector);
            };
        }

        public double cosineSimilarity() {
            return this.function.cosineSimilarity();
        }
    }

    public static class FloatCosineSimilarity
    extends FloatDenseVectorFunction
    implements CosineSimilarityInterface {
        public FloatCosineSimilarity(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field, queryVector, true);
        }

        @Override
        public double cosineSimilarity() {
            this.setNextVector();
            return this.field.get().cosineSimilarity(this.queryVector, false);
        }
    }

    public static class ByteCosineSimilarity
    extends ByteDenseVectorFunction
    implements CosineSimilarityInterface {
        public ByteCosineSimilarity(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field, queryVector);
        }

        @Override
        public double cosineSimilarity() {
            this.setNextVector();
            return this.field.get().cosineSimilarity(this.queryVector, this.qvMagnitude);
        }
    }

    public static interface CosineSimilarityInterface {
        public double cosineSimilarity();
    }

    public static final class DotProduct {
        private final DotProductInterface function;

        public DotProduct(ScoreScript scoreScript, List<Number> queryVector, String fieldName) {
            DenseVectorDocValuesField field = (DenseVectorDocValuesField)scoreScript.field(fieldName);
            this.function = switch (field.getElementType()) {
                default -> throw new IncompatibleClassChangeError();
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteDotProduct(scoreScript, field, queryVector);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatDotProduct(scoreScript, field, queryVector);
            };
        }

        public double dotProduct() {
            return this.function.dotProduct();
        }
    }

    public static class FloatDotProduct
    extends FloatDenseVectorFunction
    implements DotProductInterface {
        public FloatDotProduct(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field, queryVector, false);
        }

        @Override
        public double dotProduct() {
            this.setNextVector();
            return this.field.get().dotProduct(this.queryVector);
        }
    }

    public static class ByteDotProduct
    extends ByteDenseVectorFunction
    implements DotProductInterface {
        public ByteDotProduct(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field, queryVector);
        }

        @Override
        public double dotProduct() {
            this.setNextVector();
            return this.field.get().dotProduct(this.queryVector);
        }
    }

    public static interface DotProductInterface {
        public double dotProduct();
    }

    public static final class L2Norm {
        private final L2NormInterface function;

        public L2Norm(ScoreScript scoreScript, List<Number> queryVector, String fieldName) {
            DenseVectorDocValuesField field = (DenseVectorDocValuesField)scoreScript.field(fieldName);
            this.function = switch (field.getElementType()) {
                default -> throw new IncompatibleClassChangeError();
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteL2Norm(scoreScript, field, queryVector);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatL2Norm(scoreScript, field, queryVector);
            };
        }

        public double l2norm() {
            return this.function.l2norm();
        }
    }

    public static class FloatL2Norm
    extends FloatDenseVectorFunction
    implements L2NormInterface {
        public FloatL2Norm(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field, queryVector, false);
        }

        @Override
        public double l2norm() {
            this.setNextVector();
            return this.field.get().l2Norm(this.queryVector);
        }
    }

    public static class ByteL2Norm
    extends ByteDenseVectorFunction
    implements L2NormInterface {
        public ByteL2Norm(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field, queryVector);
        }

        @Override
        public double l2norm() {
            this.setNextVector();
            return this.field.get().l2Norm(this.queryVector);
        }
    }

    public static interface L2NormInterface {
        public double l2norm();
    }

    public static final class L1Norm {
        private final L1NormInterface function;

        public L1Norm(ScoreScript scoreScript, List<Number> queryVector, String fieldName) {
            DenseVectorDocValuesField field = (DenseVectorDocValuesField)scoreScript.field(fieldName);
            this.function = switch (field.getElementType()) {
                default -> throw new IncompatibleClassChangeError();
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteL1Norm(scoreScript, field, queryVector);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatL1Norm(scoreScript, field, queryVector);
            };
        }

        public double l1norm() {
            return this.function.l1norm();
        }
    }

    public static class FloatL1Norm
    extends FloatDenseVectorFunction
    implements L1NormInterface {
        public FloatL1Norm(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field, queryVector, false);
        }

        @Override
        public double l1norm() {
            this.setNextVector();
            return this.field.get().l1Norm(this.queryVector);
        }
    }

    public static class ByteL1Norm
    extends ByteDenseVectorFunction
    implements L1NormInterface {
        public ByteL1Norm(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field, queryVector);
        }

        @Override
        public double l1norm() {
            this.setNextVector();
            return this.field.get().l1Norm(this.queryVector);
        }
    }

    public static interface L1NormInterface {
        public double l1norm();
    }

    public static class FloatDenseVectorFunction
    extends DenseVectorFunction {
        protected final float[] queryVector;

        public FloatDenseVectorFunction(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector, boolean normalizeQuery) {
            super(scoreScript, field);
            DenseVector.checkDimensions(field.get().getDims(), queryVector.size());
            this.queryVector = new float[queryVector.size()];
            double queryMagnitude = 0.0;
            for (int i = 0; i < queryVector.size(); ++i) {
                float value;
                this.queryVector[i] = value = queryVector.get(i).floatValue();
                queryMagnitude += (double)(value * value);
            }
            queryMagnitude = Math.sqrt(queryMagnitude);
            field.getElementType().checkVectorBounds(this.queryVector);
            if (normalizeQuery) {
                int dim = 0;
                while (dim < this.queryVector.length) {
                    int n = dim++;
                    this.queryVector[n] = this.queryVector[n] / (float)queryMagnitude;
                }
            }
        }
    }

    public static class ByteDenseVectorFunction
    extends DenseVectorFunction {
        protected final byte[] queryVector;
        protected final float qvMagnitude;

        public ByteDenseVectorFunction(ScoreScript scoreScript, DenseVectorDocValuesField field, List<Number> queryVector) {
            super(scoreScript, field);
            DenseVector.checkDimensions(field.get().getDims(), queryVector.size());
            this.queryVector = new byte[queryVector.size()];
            float[] validateValues = new float[queryVector.size()];
            int queryMagnitude = 0;
            for (int i = 0; i < queryVector.size(); ++i) {
                byte value;
                Number number = queryVector.get(i);
                this.queryVector[i] = value = number.byteValue();
                queryMagnitude += value * value;
                validateValues[i] = number.floatValue();
            }
            this.qvMagnitude = (float)Math.sqrt(queryMagnitude);
            field.getElementType().checkVectorBounds(validateValues);
        }
    }

    public static class DenseVectorFunction {
        protected final ScoreScript scoreScript;
        protected final DenseVectorDocValuesField field;

        public DenseVectorFunction(ScoreScript scoreScript, DenseVectorDocValuesField field) {
            this.scoreScript = scoreScript;
            this.field = field;
        }

        void setNextVector() {
            try {
                this.field.setNextDocId(this.scoreScript._getDocId());
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
            if (this.field.isEmpty()) {
                throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
            }
        }
    }
}

