/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class NodeMetrics
extends AbstractLifecycleComponent {
    private final Logger logger = LogManager.getLogger(NodeMetrics.class);
    private final MeterRegistry registry;
    private final NodeService nodeService;
    private final List<AutoCloseable> metrics;
    private NodeStatsCache stats;

    public NodeMetrics(MeterRegistry meterRegistry, NodeService nodeService) {
        this.registry = meterRegistry;
        this.nodeService = nodeService;
        this.metrics = new ArrayList<AutoCloseable>(17);
    }

    private void registerAsyncMetrics(MeterRegistry registry) {
        this.stats = new NodeStatsCache(TimeValue.timeValueMinutes((long)1L));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.indices.get.total", "Total number of get operations", "operation", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getGet().getCount())));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.indices.get.time", "Time in milliseconds spent performing get operations.", "milliseconds", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getGet().getTimeInMillis())));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.indices.search.fetch.total", "Total number of fetch operations.", "operation", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getSearch().getTotal().getFetchCount())));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.indices.search.fetch.time", "Time in milliseconds spent performing fetch operations.", "milliseconds", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getSearch().getTotal().getFetchTimeInMillis())));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.indices.merge.total", "Total number of merge operations.", "operation", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getMerge().getTotal())));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.indices.merge.time", "Time in milliseconds spent performing merge operations.", "milliseconds", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getMerge().getTotalTimeInMillis())));
        this.metrics.add(registry.registerLongGauge("es.node.stats.indices.translog.operations", "Number of transaction log operations.", "operation", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getTranslog().estimatedNumberOfOperations())));
        this.metrics.add(registry.registerLongGauge("es.node.stats.indices.translog.size", "Size, in bytes, of the transaction log.", "bytes", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getTranslog().getTranslogSizeInBytes())));
        this.metrics.add(registry.registerLongGauge("es.node.stats.indices.translog.uncommitted_operations", "Number of uncommitted transaction log operations.", "operations", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getTranslog().getUncommittedOperations())));
        this.metrics.add(registry.registerLongGauge("es.node.stats.indices.translog.uncommitted_size", "Size, in bytes, of uncommitted transaction log operations.", "bytes", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getTranslog().getUncommittedSizeInBytes())));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.indices.translog.earliest_last_modified_age", "Earliest last modified age for the transaction log.", "time", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getIndices().getTranslog().getEarliestLastModifiedAge())));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.transport.rx_size", "Size, in bytes, of RX packets received by the node during internal cluster communication.", "bytes", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getTransport().getRxSize().getBytes())));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.transport.tx_size", "Size, in bytes, of TX packets sent by the node during internal cluster communication.", "bytes", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getTransport().getTxSize().getBytes())));
        this.metrics.add(registry.registerLongGauge("es.node.stats.jvm.mem.pools.young.used", "Memory, in bytes, used by the young generation heap.", "bytes", () -> new LongWithAttributes(this.bytesUsedByGCGen(((NodeStats)this.stats.getOrRefresh()).getJvm().getMem(), "young"))));
        this.metrics.add(registry.registerLongGauge("es.node.stats.jvm.mem.pools.survivor.used", "Memory, in bytes, used by the survivor space.", "bytes", () -> new LongWithAttributes(this.bytesUsedByGCGen(((NodeStats)this.stats.getOrRefresh()).getJvm().getMem(), "survivor"))));
        this.metrics.add(registry.registerLongGauge("es.node.stats.jvm.mem.pools.old.used", "Memory, in bytes, used by the old generation heap.", "bytes", () -> new LongWithAttributes(this.bytesUsedByGCGen(((NodeStats)this.stats.getOrRefresh()).getJvm().getMem(), "old"))));
        this.metrics.add(registry.registerLongAsyncCounter("es.node.stats.fs.io_stats.io_time.total", "The total time in millis spent performing I/O operations across all devices used by Elasticsearch.", "milliseconds", () -> new LongWithAttributes(((NodeStats)this.stats.getOrRefresh()).getFs().getIoStats().getTotalIOTimeMillis())));
    }

    private long bytesUsedByGCGen(JvmStats.Mem mem, String name) {
        long bytesUsed = 0L;
        for (JvmStats.MemoryPool pool : mem) {
            if (!pool.getName().equals(name)) continue;
            bytesUsed = pool.getUsed().getBytes();
        }
        return bytesUsed;
    }

    private NodeStats getNodeStats() {
        CommonStatsFlags flags = new CommonStatsFlags(CommonStatsFlags.Flag.Get, CommonStatsFlags.Flag.Search, CommonStatsFlags.Flag.Merge, CommonStatsFlags.Flag.Translog);
        return this.nodeService.stats(flags, true, false, false, true, false, true, true, false, false, false, false, false, false, false, false, false);
    }

    @Override
    protected void doStart() {
        this.registerAsyncMetrics(this.registry);
    }

    @Override
    protected void doStop() {
        this.stats.stopRefreshing();
    }

    @Override
    protected void doClose() throws IOException {
        this.metrics.forEach(metric -> {
            try {
                metric.close();
            }
            catch (Exception e) {
                this.logger.warn("metrics close() method should not throw Exception", (Throwable)e);
            }
        });
    }

    private class NodeStatsCache
    extends SingleObjectCache<NodeStats> {
        private boolean refresh;

        NodeStatsCache(TimeValue interval) {
            super(interval, NodeMetrics.this.getNodeStats());
            this.refresh = true;
        }

        @Override
        protected NodeStats refresh() {
            return this.refresh ? NodeMetrics.this.getNodeStats() : (NodeStats)this.getNoRefresh();
        }

        public void stopRefreshing() {
            this.refresh = false;
        }
    }
}

