/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ingest.SimulateProcessorResult;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.ConditionalProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;

public final class TrackingResultProcessor
implements Processor {
    private final Processor actualProcessor;
    private final ConditionalProcessor conditionalProcessor;
    private final List<SimulateProcessorResult> processorResultList;
    private final boolean ignoreFailure;

    TrackingResultProcessor(boolean ignoreFailure, Processor actualProcessor, ConditionalProcessor conditionalProcessor, List<SimulateProcessorResult> processorResultList) {
        this.ignoreFailure = ignoreFailure;
        this.processorResultList = processorResultList;
        this.actualProcessor = actualProcessor;
        this.conditionalProcessor = conditionalProcessor;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        Tuple conditionalWithResult;
        if (this.conditionalProcessor != null) {
            if (!this.conditionalProcessor.evaluate(ingestDocument)) {
                Tuple conditionalWithResult2 = new Tuple((Object)this.conditionalProcessor.getCondition(), (Object)Boolean.FALSE);
                this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), (Tuple<String, Boolean>)conditionalWithResult2));
                handler.accept(ingestDocument, null);
                return;
            }
            conditionalWithResult = new Tuple((Object)this.conditionalProcessor.getCondition(), (Object)Boolean.TRUE);
        } else {
            conditionalWithResult = null;
        }
        Processor processor = this.actualProcessor;
        if (processor instanceof PipelineProcessor) {
            PipelineProcessor pipelineProcessor = (PipelineProcessor)processor;
            Pipeline pipeline = pipelineProcessor.getPipeline(ingestDocument);
            IngestDocument ingestDocumentCopy = new IngestDocument(ingestDocument);
            Pipeline pipelineToCall = pipelineProcessor.getPipeline(ingestDocument);
            if (pipelineToCall == null) {
                IllegalArgumentException e2 = new IllegalArgumentException("Pipeline processor configured for non-existent pipeline [" + pipelineProcessor.getPipelineToCallName(ingestDocument) + "]");
                this.processorResultList.add(new SimulateProcessorResult(pipelineProcessor.getType(), pipelineProcessor.getTag(), pipelineProcessor.getDescription(), e2, (Tuple<String, Boolean>)conditionalWithResult));
                throw e2;
            }
            ingestDocumentCopy.executePipeline(pipelineToCall, (result, e) -> {
                if (e instanceof ElasticsearchException && e.getCause() instanceof IllegalStateException && e.getCause().getMessage().startsWith("Cycle detected for pipeline: ")) {
                    if (this.ignoreFailure) {
                        this.processorResultList.add(new SimulateProcessorResult(pipelineProcessor.getType(), pipelineProcessor.getTag(), pipelineProcessor.getDescription(), ingestDocument, (Exception)e, (Tuple<String, Boolean>)conditionalWithResult));
                    } else {
                        this.processorResultList.add(new SimulateProcessorResult(pipelineProcessor.getType(), pipelineProcessor.getTag(), pipelineProcessor.getDescription(), (Exception)e, (Tuple<String, Boolean>)conditionalWithResult));
                    }
                    handler.accept((IngestDocument)null, (Exception)e);
                } else {
                    CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), null, this.processorResultList);
                    this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), (Tuple<String, Boolean>)conditionalWithResult));
                    Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), pipeline.getMetadata(), verbosePipelineProcessor, pipeline.getDeprecated());
                    ingestDocument.executePipeline(verbosePipeline, handler);
                }
            });
            return;
        }
        TrackingResultProcessor.executeProcessor(this.actualProcessor, ingestDocument, (result, e) -> {
            if (e != null) {
                if (this.ignoreFailure) {
                    this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), ingestDocument, (Exception)e, (Tuple<String, Boolean>)conditionalWithResult));
                } else {
                    this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), (Exception)e, (Tuple<String, Boolean>)conditionalWithResult));
                }
                handler.accept((IngestDocument)null, (Exception)e);
            } else if (result != null) {
                this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), ingestDocument, (Tuple<String, Boolean>)conditionalWithResult));
                handler.accept((IngestDocument)result, (Exception)null);
            } else {
                this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getType(), this.actualProcessor.getTag(), this.actualProcessor.getDescription(), (Tuple<String, Boolean>)conditionalWithResult));
                handler.accept(null, null);
            }
        });
    }

    private static void executeProcessor(Processor p, IngestDocument doc, BiConsumer<IngestDocument, Exception> handler) {
        if (p.isAsync()) {
            p.execute(doc, handler);
        } else {
            try {
                IngestDocument result = p.execute(doc);
                handler.accept(result, null);
            }
            catch (Exception e) {
                handler.accept(null, e);
            }
        }
    }

    @Override
    public String getType() {
        return this.actualProcessor.getType();
    }

    @Override
    public String getTag() {
        return this.actualProcessor.getTag();
    }

    @Override
    public String getDescription() {
        return this.actualProcessor.getDescription();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    public static CompoundProcessor decorate(CompoundProcessor compoundProcessor, ConditionalProcessor parentCondition, List<SimulateProcessorResult> processorResultList) {
        ArrayList<Processor> processors = new ArrayList<Processor>();
        for (Processor processor : compoundProcessor.getProcessors()) {
            Processor cp;
            ConditionalProcessor conditionalProcessor = parentCondition;
            if (processor instanceof ConditionalProcessor) {
                conditionalProcessor = cp = (ConditionalProcessor)processor;
                processor = conditionalProcessor.getInnerProcessor();
            }
            if (processor instanceof CompoundProcessor) {
                cp = (CompoundProcessor)processor;
                processors.add(TrackingResultProcessor.decorate((CompoundProcessor)cp, conditionalProcessor, processorResultList));
                continue;
            }
            processors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, conditionalProcessor, processorResultList));
        }
        ArrayList<Processor> onFailureProcessors = new ArrayList<Processor>(compoundProcessor.getProcessors().size());
        for (Processor processor : compoundProcessor.getOnFailureProcessors()) {
            Processor cp;
            ConditionalProcessor conditionalProcessor = null;
            if (processor instanceof ConditionalProcessor) {
                conditionalProcessor = cp = (ConditionalProcessor)processor;
                processor = conditionalProcessor.getInnerProcessor();
            }
            if (processor instanceof CompoundProcessor) {
                cp = (CompoundProcessor)processor;
                onFailureProcessors.add(TrackingResultProcessor.decorate((CompoundProcessor)cp, conditionalProcessor, processorResultList));
                continue;
            }
            onFailureProcessors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, conditionalProcessor, processorResultList));
        }
        return new CompoundProcessor(compoundProcessor.isIgnoreFailure(), processors, onFailureProcessors);
    }
}

