/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis.wrappers;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.analysis.wrappers.SettingsInvocationHandler;
import org.elasticsearch.plugin.Inject;
import org.elasticsearch.plugin.analysis.AnalyzerFactory;
import org.elasticsearch.plugin.analysis.TokenizerFactory;
import org.elasticsearch.plugin.settings.AnalysisSettings;
import org.elasticsearch.plugins.scanners.PluginInfo;
import org.elasticsearch.plugins.scanners.StablePluginsRegistry;

public class StableApiWrappers {
    public static Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> oldApiForStableCharFilterFactory(StablePluginsRegistry stablePluginRegistry) {
        return StableApiWrappers.mapStablePluginApiToOld(stablePluginRegistry, org.elasticsearch.plugin.analysis.CharFilterFactory.class, StableApiWrappers::wrapCharFilterFactory);
    }

    public static Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> oldApiForTokenFilterFactory(StablePluginsRegistry stablePluginRegistry) {
        return StableApiWrappers.mapStablePluginApiToOld(stablePluginRegistry, org.elasticsearch.plugin.analysis.TokenFilterFactory.class, StableApiWrappers::wrapTokenFilterFactory);
    }

    public static Map<String, AnalysisModule.AnalysisProvider<org.elasticsearch.index.analysis.TokenizerFactory>> oldApiForTokenizerFactory(StablePluginsRegistry stablePluginRegistry) {
        return StableApiWrappers.mapStablePluginApiToOld(stablePluginRegistry, TokenizerFactory.class, StableApiWrappers::wrapTokenizerFactory);
    }

    public static Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> oldApiForAnalyzerFactory(StablePluginsRegistry stablePluginRegistry) {
        return StableApiWrappers.mapStablePluginApiToOld(stablePluginRegistry, AnalyzerFactory.class, StableApiWrappers::wrapAnalyzerFactory);
    }

    private static <T, F> Map<String, AnalysisModule.AnalysisProvider<T>> mapStablePluginApiToOld(StablePluginsRegistry stablePluginRegistry, Class<F> charFilterFactoryClass, Function<F, T> wrapper) {
        Collection<PluginInfo> pluginInfosForExtensible = stablePluginRegistry.getPluginInfosForExtensible(charFilterFactoryClass.getCanonicalName());
        Map<String, AnalysisModule.AnalysisProvider<T>> oldApiComponents = pluginInfosForExtensible.stream().collect(Collectors.toMap(PluginInfo::name, p -> StableApiWrappers.analysisProviderWrapper(p, wrapper)));
        return oldApiComponents;
    }

    private static <F, T> AnalysisModule.AnalysisProvider<T> analysisProviderWrapper(final PluginInfo pluginInfo, final Function<F, T> wrapper) {
        return new AnalysisModule.AnalysisProvider<T>(){

            @Override
            public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
                try {
                    Class<?> clazz = pluginInfo.loader().loadClass(pluginInfo.className());
                    Object instance = StableApiWrappers.createInstance(clazz, indexSettings, environment.settings(), settings, environment);
                    return wrapper.apply(instance);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Plugin classloader cannot find class " + pluginInfo.className(), e);
                }
            }
        };
    }

    private static CharFilterFactory wrapCharFilterFactory(final org.elasticsearch.plugin.analysis.CharFilterFactory charFilterFactory) {
        return new CharFilterFactory(){

            @Override
            public String name() {
                return charFilterFactory.name();
            }

            @Override
            public Reader create(Reader reader) {
                return charFilterFactory.create(reader);
            }

            @Override
            public Reader normalize(Reader reader) {
                return charFilterFactory.normalize(reader);
            }
        };
    }

    private static TokenFilterFactory wrapTokenFilterFactory(final org.elasticsearch.plugin.analysis.TokenFilterFactory f) {
        return new TokenFilterFactory(){

            @Override
            public String name() {
                return f.name();
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return f.create(tokenStream);
            }

            @Override
            public TokenStream normalize(TokenStream tokenStream) {
                return f.normalize(tokenStream);
            }

            @Override
            public AnalysisMode getAnalysisMode() {
                return 3.mapAnalysisMode(f.getAnalysisMode());
            }

            private static AnalysisMode mapAnalysisMode(org.elasticsearch.plugin.analysis.AnalysisMode analysisMode) {
                return AnalysisMode.valueOf(analysisMode.name());
            }
        };
    }

    private static org.elasticsearch.index.analysis.TokenizerFactory wrapTokenizerFactory(final TokenizerFactory f) {
        return new org.elasticsearch.index.analysis.TokenizerFactory(){

            @Override
            public String name() {
                return f.name();
            }

            @Override
            public Tokenizer create() {
                return f.create();
            }
        };
    }

    private static AnalyzerProvider<?> wrapAnalyzerFactory(final AnalyzerFactory f) {
        return new AnalyzerProvider<Analyzer>(){

            @Override
            public String name() {
                return f.name();
            }

            @Override
            public AnalyzerScope scope() {
                return AnalyzerScope.GLOBAL;
            }

            @Override
            public Analyzer get() {
                return f.create();
            }
        };
    }

    private static <T> T createInstance(Class<T> clazz, IndexSettings indexSettings, Settings nodeSettings, Settings analysisSettings, Environment environment) {
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length > 1) {
                throw new IllegalStateException("Plugin can only have one public constructor.");
            }
            Constructor<?> constructor = constructors[0];
            if (constructor.getParameterCount() == 0) {
                return (T)constructor.newInstance(new Object[0]);
            }
            Inject inject = constructor.getAnnotation(Inject.class);
            if (inject != null) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                Object[] parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Object settings = StableApiWrappers.createSettings(parameterTypes[i], indexSettings, nodeSettings, analysisSettings, environment);
                    parameters[i] = settings;
                }
                return (T)constructor.newInstance(parameters);
            }
            throw new IllegalStateException("Missing @Inject annotation for constructor with settings.");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot create instance of " + clazz, e);
        }
    }

    private static <T> T createSettings(Class<T> settingsClass, IndexSettings indexSettings, Settings nodeSettings, Settings analysisSettings, Environment environment) {
        if (((AnalysisSettings[])settingsClass.getAnnotationsByType(AnalysisSettings.class)).length > 0) {
            return SettingsInvocationHandler.create(analysisSettings, settingsClass, environment);
        }
        throw new IllegalArgumentException("Parameter is not instance of a class annotated with settings annotation.");
    }
}

