/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedNumericIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.DateRangeIncludingNowQuery;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.DateFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.SortedNumericDocValuesLongFieldScript;
import org.elasticsearch.script.field.DateMillisDocValuesField;
import org.elasticsearch.script.field.DateNanosDocValuesField;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.runtime.LongScriptFieldDistanceFeatureQuery;
import org.elasticsearch.xcontent.XContentBuilder;

public final class DateFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(DateFieldMapper.class);
    private static final Logger logger = LogManager.getLogger(DateFieldMapper.class);
    public static final String CONTENT_TYPE = "date";
    public static final String DATE_NANOS_CONTENT_TYPE = "date_nanos";
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time||epoch_millis");
    public static final DateFormatter DEFAULT_DATE_TIME_NANOS_FORMATTER = DateFormatter.forPattern("strict_date_optional_time_nanos||epoch_millis");
    private static final DateMathParser EPOCH_MILLIS_PARSER = DateFormatter.forPattern("epoch_millis").toDateMathParser();
    private static final IndexVersion MINIMUM_COMPATIBILITY_VERSION = IndexVersion.fromId(5000099);
    public static final FieldMapper.TypeParser MILLIS_PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, Resolution.MILLISECONDS, c.getDateFormatter(), c.scriptCompiler(), ignoreMalformedByDefault, c.indexVersionCreated());
    }, MINIMUM_COMPATIBILITY_VERSION);
    public static final FieldMapper.TypeParser NANOS_PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, Resolution.NANOSECONDS, c.getDateFormatter(), c.scriptCompiler(), ignoreMalformedByDefault, c.indexVersionCreated());
    }, MINIMUM_COMPATIBILITY_VERSION);
    private final boolean store;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final Locale locale;
    private final String format;
    private final boolean ignoreMalformed;
    private final Long nullValue;
    private final String nullValueAsString;
    private final Resolution resolution;
    private final boolean ignoreMalformedByDefault;
    private final IndexVersion indexCreatedVersion;
    private final Script script;
    private final ScriptCompiler scriptCompiler;
    private final FieldValues<Long> scriptValues;

    private static DateFieldMapper toType(FieldMapper in) {
        return (DateFieldMapper)in;
    }

    private DateFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Long nullValue, Resolution resolution, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo, builder.script.get() != null, builder.onScriptError.get());
        this.store = builder.store.getValue();
        this.indexed = builder.index.getValue();
        this.hasDocValues = builder.docValues.getValue();
        this.locale = builder.locale.getValue();
        this.format = builder.format.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.nullValueAsString = builder.nullValue.getValue();
        this.nullValue = nullValue;
        this.resolution = resolution;
        this.ignoreMalformedByDefault = builder.ignoreMalformed.getDefaultValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.script = builder.script.get();
        this.scriptCompiler = builder.scriptCompiler;
        this.scriptValues = builder.scriptValues();
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.resolution, null, this.scriptCompiler, this.ignoreMalformedByDefault, this.indexCreatedVersion).init(this);
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().resolution.type();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        long timestamp;
        String dateAsString = context.parser().textOrNull();
        if (dateAsString == null) {
            if (this.nullValue == null) {
                return;
            }
            timestamp = this.nullValue;
        } else {
            try {
                timestamp = this.fieldType().parse(dateAsString);
            }
            catch (ArithmeticException | IllegalArgumentException | DateTimeException | ElasticsearchParseException e) {
                if (this.ignoreMalformed) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
        }
        this.indexValue(context, timestamp);
    }

    private void indexValue(DocumentParserContext context, long timestamp) {
        if (this.indexed && this.hasDocValues) {
            context.doc().add((IndexableField)new LongField(this.fieldType().name(), timestamp));
        } else if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), timestamp));
        } else if (this.indexed) {
            context.doc().add((IndexableField)new LongPoint(this.fieldType().name(), new long[]{timestamp}));
        }
        if (this.store) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), timestamp));
        }
        if (!this.hasDocValues && (this.indexed || this.store)) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, v -> this.indexValue(documentParserContext, (long)v));
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public Long getNullValue() {
        return this.nullValue;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        if (this.hasScript) {
            return SourceLoader.SyntheticFieldLoader.NOTHING;
        }
        if (!this.hasDocValues) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it doesn't have doc values");
        }
        if (this.ignoreMalformed) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it ignores malformed dates");
        }
        if (!this.copyTo.copyToFields().isEmpty()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it declares copy_to");
        }
        return new SortedNumericDocValuesSyntheticFieldLoader(this.name(), this.simpleName(), this.ignoreMalformed){

            @Override
            protected void writeValue(XContentBuilder b, long value) throws IOException {
                b.value(DateFieldMapper.this.fieldType().format(value, DateFieldMapper.this.fieldType().dateTimeFormatter()));
            }
        };
    }

    public static final class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> DateFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> DateFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> DateFieldMapper.toType((FieldMapper)m).store, false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<String> format;
        private final FieldMapper.Parameter<Locale> locale = new FieldMapper.Parameter<Locale>("locale", false, () -> Locale.ROOT, (n, c, o) -> LocaleUtils.parse(o.toString()), m -> DateFieldMapper.toType((FieldMapper)m).locale, (xContentBuilder, n, v) -> xContentBuilder.field(n, v.toString()), Objects::toString);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> DateFieldMapper.toType((FieldMapper)m).nullValueAsString, null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> DateFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> DateFieldMapper.toType((FieldMapper)m).onScriptError, this.script);
        private final Resolution resolution;
        private final IndexVersion indexCreatedVersion;
        private final ScriptCompiler scriptCompiler;

        public Builder(String name, Resolution resolution, DateFormatter dateFormatter, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault, IndexVersion indexCreatedVersion) {
            super(name);
            this.resolution = resolution;
            this.indexCreatedVersion = indexCreatedVersion;
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.ignoreMalformed = FieldMapper.Parameter.boolParam("ignore_malformed", true, m -> DateFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed);
            this.addScriptValidation(this.script, this.index, this.docValues);
            DateFormatter defaultFormat = resolution == Resolution.MILLISECONDS ? DEFAULT_DATE_TIME_FORMATTER : DEFAULT_DATE_TIME_NANOS_FORMATTER;
            this.format = FieldMapper.Parameter.stringParam("format", indexCreatedVersion.isLegacyIndexVersion(), m -> DateFieldMapper.toType((FieldMapper)m).format, defaultFormat.pattern());
            if (dateFormatter != null) {
                this.format.setValue(dateFormatter.pattern());
                this.locale.setValue(dateFormatter.locale());
            }
        }

        DateFormatter buildFormatter() {
            try {
                return DateFormatter.forPattern(this.format.getValue(), this.indexCreatedVersion).withLocale(this.locale.getValue());
            }
            catch (IllegalArgumentException e) {
                if (this.indexCreatedVersion.isLegacyIndexVersion()) {
                    logger.warn(() -> "Error parsing format [" + this.format.getValue() + "] of legacy index, falling back to default", (Throwable)e);
                    return DateFormatter.forPattern(this.format.getDefaultValue()).withLocale(this.locale.getValue());
                }
                throw new IllegalArgumentException("Error parsing [format] on field [" + this.name() + "]: " + e.getMessage(), e);
            }
        }

        private FieldValues<Long> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            DateFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), DateFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.name, this.script.get().getParams(), lookup, this.buildFormatter(), OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer::accept);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.index, this.docValues, this.store, this.format, this.locale, this.nullValue, this.ignoreMalformed, this.script, this.onScriptError, this.meta};
        }

        private Long parseNullValue(DateFieldType fieldType) {
            if (this.nullValue.getValue() == null) {
                return null;
            }
            try {
                return fieldType.parse(this.nullValue.getValue());
            }
            catch (Exception e) {
                if (this.indexCreatedVersion.onOrAfter(IndexVersions.V_8_0_0)) {
                    throw new MapperParsingException("Error parsing [null_value] on field [" + this.name() + "]: " + e.getMessage(), e);
                }
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "date_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as date in [null_value] on field [" + this.name() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        @Override
        public DateFieldMapper build(MapperBuilderContext context) {
            DateFieldType ft = new DateFieldType(context.buildFullName(this.name()), this.index.getValue() != false && !this.indexCreatedVersion.isLegacyIndexVersion(), this.index.getValue(), this.store.getValue(), this.docValues.getValue(), this.buildFormatter(), this.resolution, this.nullValue.getValue(), this.scriptValues(), this.meta.getValue());
            Long nullTimestamp = this.parseNullValue(ft);
            if (this.name().equals("@timestamp") && context.isDataStream() && !this.ignoreMalformed.isConfigured()) {
                this.ignoreMalformed.setValue(false);
            }
            return new DateFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo, nullTimestamp, this.resolution, this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Resolution {
        MILLISECONDS("date", IndexNumericFieldData.NumericType.DATE, DateMillisDocValuesField::new){

            @Override
            public long convert(Instant instant) {
                return instant.toEpochMilli();
            }

            @Override
            public long convert(TimeValue timeValue) {
                return timeValue.millis();
            }

            @Override
            public Instant toInstant(long value) {
                return Instant.ofEpochMilli(value);
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return LongPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public long roundDownToMillis(long value) {
                return value;
            }

            @Override
            public long roundUpToMillis(long value) {
                return value;
            }
        }
        ,
        NANOSECONDS("date_nanos", IndexNumericFieldData.NumericType.DATE_NANOSECONDS, DateNanosDocValuesField::new){

            @Override
            public long convert(Instant instant) {
                return DateUtils.toLong(instant);
            }

            @Override
            public long convert(TimeValue timeValue) {
                return timeValue.nanos();
            }

            @Override
            public Instant toInstant(long value) {
                return DateUtils.toInstant(value);
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return this.roundDownToMillis(LongPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public long roundDownToMillis(long value) {
                return DateUtils.toMilliSeconds(value);
            }

            @Override
            public long roundUpToMillis(long value) {
                if (value <= 0L) {
                    return DateUtils.toMilliSeconds(value);
                }
                return DateUtils.toMilliSeconds(value - 1L) + 1L;
            }
        };

        private final String type;
        private final IndexNumericFieldData.NumericType numericType;
        private final ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory;

        private Resolution(String type, IndexNumericFieldData.NumericType numericType, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
            this.type = type;
            this.numericType = numericType;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public String type() {
            return this.type;
        }

        IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        ToScriptFieldFactory<SortedNumericDocValues> getDefaultToScriptFieldFactory() {
            return this.toScriptFieldFactory;
        }

        public abstract long convert(Instant var1);

        public abstract Instant toInstant(long var1);

        public abstract long convert(TimeValue var1);

        public abstract long parsePointAsMillis(byte[] var1);

        public abstract long roundDownToMillis(long var1);

        public abstract long roundUpToMillis(long var1);

        public static Resolution ofOrdinal(int ord) {
            for (Resolution resolution : Resolution.values()) {
                if (ord != resolution.ordinal()) continue;
                return resolution;
            }
            throw new IllegalArgumentException("unknown resolution ordinal [" + ord + "]");
        }
    }

    public static final class DateFieldType
    extends MappedFieldType {
        final DateFormatter dateTimeFormatter;
        final DateMathParser dateMathParser;
        private final Resolution resolution;
        private final String nullValue;
        private final FieldValues<Long> scriptValues;
        private final boolean pointsMetadataAvailable;
        private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.ROOT);

        public DateFieldType(String name, boolean isIndexed, boolean pointsMetadataAvailable, boolean isStored, boolean hasDocValues, DateFormatter dateTimeFormatter, Resolution resolution, String nullValue, FieldValues<Long> scriptValues, Map<String, String> meta) {
            super(name, isIndexed, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = dateTimeFormatter.toDateMathParser();
            this.resolution = resolution;
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
            this.pointsMetadataAvailable = pointsMetadataAvailable;
        }

        public DateFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, DateFormatter dateTimeFormatter, Resolution resolution, String nullValue, FieldValues<Long> scriptValues, Map<String, String> meta) {
            this(name, isIndexed, isIndexed, isStored, hasDocValues, dateTimeFormatter, resolution, nullValue, scriptValues, meta);
        }

        public DateFieldType(String name) {
            this(name, true, true, false, true, DEFAULT_DATE_TIME_FORMATTER, Resolution.MILLISECONDS, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, boolean isIndexed) {
            this(name, isIndexed, isIndexed, false, true, DEFAULT_DATE_TIME_FORMATTER, Resolution.MILLISECONDS, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, DateFormatter dateFormatter) {
            this(name, true, true, false, true, dateFormatter, Resolution.MILLISECONDS, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, Resolution resolution) {
            this(name, true, true, false, true, DEFAULT_DATE_TIME_FORMATTER, resolution, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, Resolution resolution, DateFormatter dateFormatter) {
            this(name, true, true, false, true, dateFormatter, resolution, null, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.resolution.type();
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public Resolution resolution() {
            return this.resolution;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        public long parse(String value) {
            return this.resolution.convert(DateFormatters.from(this.dateTimeFormatter().parse(value), this.dateTimeFormatter().locale()).toInstant());
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            DateFormatter formatter;
            DateFormatter defaultFormatter = this.dateTimeFormatter();
            DateFormatter dateFormatter = formatter = format != null ? DateFormatter.forPattern(format).withLocale(defaultFormatter.locale()) : defaultFormatter;
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, v -> this.format((Long)v, formatter), context);
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                public String parseSourceValue(Object value) {
                    String date = value instanceof Number ? NUMBER_FORMAT.format(value) : value.toString();
                    return this.format(this.parse(date), formatter);
                }
            };
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths) {
            return new SourceValueFetcher(sourcePaths, (Object)this.nullValue){

                @Override
                public Long parseSourceValue(Object value) {
                    String date = value instanceof Number ? NUMBER_FORMAT.format(value) : value.toString();
                    return this.parse(date);
                }
            };
        }

        private String format(long timestamp, DateFormatter formatter) {
            ZonedDateTime dateTime = this.resolution().toInstant(timestamp).atZone(ZoneOffset.UTC);
            return formatter.format(dateTime);
        }

        @Override
        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }

        @Override
        public Query termQuery(Object value, @Nullable SearchExecutionContext context) {
            return this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser forcedDateParser, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (relation == ShapeRelation.DISJOINT) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support DISJOINT ranges");
            }
            DateMathParser parser = forcedDateParser == null ? (lowerTerm instanceof Number || upperTerm instanceof Number ? EPOCH_MILLIS_PARSER : this.dateMathParser) : forcedDateParser;
            return DateFieldType.dateRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context, this.resolution, (l, u) -> {
                Query query;
                if (this.isIndexed()) {
                    query = LongPoint.newRangeQuery((String)this.name(), (long)l, (long)u);
                    if (this.hasDocValues()) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)this.name(), (long)l, (long)u);
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                } else {
                    query = SortedNumericDocValuesField.newSlowRangeQuery((String)this.name(), (long)l, (long)u);
                }
                if (this.hasDocValues() && context.indexSortedOnField(this.name())) {
                    query = new IndexSortSortedNumericDocValuesRangeQuery(this.name(), l.longValue(), u.longValue(), query);
                }
                return query;
            });
        }

        public static Query dateRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable ZoneId timeZone, DateMathParser parser, SearchExecutionContext context, Resolution resolution, BiFunction<Long, Long, Query> builder) {
            return DateFieldType.handleNow(context, nowSupplier -> {
                long u;
                long l;
                if (lowerTerm == null) {
                    l = Long.MIN_VALUE;
                } else {
                    l = DateFieldType.parseToLong(lowerTerm, !includeLower, timeZone, parser, nowSupplier, resolution);
                    if (!includeLower) {
                        ++l;
                    }
                }
                if (upperTerm == null) {
                    u = Long.MAX_VALUE;
                } else {
                    u = DateFieldType.parseToLong(upperTerm, includeUpper, timeZone, parser, nowSupplier, resolution);
                    if (!includeUpper) {
                        --u;
                    }
                }
                return (Query)builder.apply(l, u);
            });
        }

        public static Query handleNow(SearchExecutionContext context, Function<LongSupplier, Query> builder) {
            boolean[] nowUsed = new boolean[1];
            LongSupplier nowSupplier = () -> {
                nowUsed[0] = true;
                return context.nowInMillis();
            };
            Query query = builder.apply(nowSupplier);
            return nowUsed[0] ? new DateRangeIncludingNowQuery(query) : query;
        }

        public long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now) {
            dateParser = dateParser == null ? this.dateMathParser() : dateParser;
            return DateFieldType.parseToLong(value, roundUp, zone, dateParser, now, this.resolution);
        }

        public static long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now, Resolution resolution) {
            return resolution.convert(dateParser.parse(BytesRefs.toString(value), now, roundUp, zone));
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            long originLong = this.parseToLong(origin, true, null, null, context::nowInMillis);
            TimeValue pivotTime = TimeValue.parseTimeValue((String)pivot, (String)"distance_feature.pivot");
            long pivotLong = this.resolution.convert(pivotTime);
            if (this.isIndexed()) {
                return LongPoint.newDistanceFeatureQuery((String)this.name(), (float)1.0f, (long)originLong, (long)pivotLong);
            }
            return new LongScriptFieldDistanceFeatureQuery(new Script(""), ctx -> new SortedNumericDocValuesLongFieldScript(this.name(), context.lookup(), (LeafReaderContext)ctx), this.name(), originLong, pivotLong);
        }

        @Override
        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (!this.isIndexed() && !this.pointsMetadataAvailable && this.hasDocValues()) {
                return MappedFieldType.Relation.INTERSECTS;
            }
            byte[] minPackedValue = PointValues.getMinPackedValue((IndexReader)reader, (String)this.name());
            if (minPackedValue == null) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minValue = LongPoint.decodeDimension((byte[])minPackedValue, (int)0);
            long maxValue = LongPoint.decodeDimension((byte[])PointValues.getMaxPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            return this.isFieldWithinQuery(minValue, maxValue, from, to, includeLower, includeUpper, timeZone, dateParser, context);
        }

        public MappedFieldType.Relation isFieldWithinQuery(long minValue, long maxValue, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) {
            if (dateParser == null) {
                dateParser = from instanceof Number || to instanceof Number ? EPOCH_MILLIS_PARSER : this.dateMathParser;
            }
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = DateFieldType.parseToLong(from, !includeLower, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = DateFieldType.parseToLong(to, includeUpper, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return MappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return MappedFieldType.Relation.DISJOINT;
            }
            return MappedFieldType.Relation.INTERSECTS;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isIndexed()) {
                return this.resolution()::parsePointAsMillis;
            }
            return null;
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues()) {
                return new BlockDocValuesReader.LongsBlockLoader(this.name());
            }
            return new BlockSourceReader.LongsBlockLoader(this.sourceValueFetcher(blContext.sourcePaths(this.name())));
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
            }
            if ((operation == MappedFieldType.FielddataOperation.SEARCH || operation == MappedFieldType.FielddataOperation.SCRIPT) && this.hasDocValues()) {
                return new SortedNumericIndexFieldData.Builder(this.name(), this.resolution.numericType(), this.resolution.getDefaultToScriptFieldFactory());
            }
            if (operation == MappedFieldType.FielddataOperation.SCRIPT) {
                SearchLookup searchLookup = fieldDataContext.lookupSupplier().get();
                Set<String> sourcePaths = fieldDataContext.sourcePathsLookup().apply(this.name());
                return new SourceValueFetcherSortedNumericIndexFieldData.Builder(this.name(), this.resolution.numericType().getValuesSourceType(), (ValueFetcher)this.sourceValueFetcher(sourcePaths), (SourceProvider)searchLookup, this.resolution.getDefaultToScriptFieldFactory());
            }
            throw new IllegalStateException("unknown field data operation [" + operation.name() + "]");
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().format(this.resolution.toInstant(val).atZone(ZoneOffset.UTC));
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            DateFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
            }
            if (timeZone == null) {
                timeZone = ZoneOffset.UTC;
            }
            return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, Resolution.MILLISECONDS);
        }

        static {
            NUMBER_FORMAT.setGroupingUsed(false);
            NUMBER_FORMAT.setMaximumFractionDigits(6);
        }
    }
}

