/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node.selection;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.health.HealthFeatures;
import org.elasticsearch.health.node.selection.HealthNode;
import org.elasticsearch.health.node.selection.HealthNodeTaskParams;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;

public final class HealthNodeTaskExecutor
extends PersistentTasksExecutor<HealthNodeTaskParams> {
    private static final Logger logger = LogManager.getLogger(HealthNodeTaskExecutor.class);
    public static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting("health.node.enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final PersistentTasksService persistentTasksService;
    private final FeatureService featureService;
    private final AtomicReference<HealthNode> currentTask = new AtomicReference();
    private final ClusterStateListener taskStarter;
    private final ClusterStateListener shutdownListener;
    private volatile boolean enabled;

    private HealthNodeTaskExecutor(ClusterService clusterService, PersistentTasksService persistentTasksService, FeatureService featureService, Settings settings) {
        super("health-node", "management");
        this.clusterService = clusterService;
        this.persistentTasksService = persistentTasksService;
        this.featureService = featureService;
        this.taskStarter = this::startTask;
        this.shutdownListener = this::shuttingDown;
        this.enabled = ENABLED_SETTING.get(settings);
    }

    public static HealthNodeTaskExecutor create(ClusterService clusterService, PersistentTasksService persistentTasksService, FeatureService featureService, Settings settings, ClusterSettings clusterSettings) {
        HealthNodeTaskExecutor healthNodeTaskExecutor = new HealthNodeTaskExecutor(clusterService, persistentTasksService, featureService, settings);
        healthNodeTaskExecutor.registerListeners(clusterSettings);
        return healthNodeTaskExecutor;
    }

    private void registerListeners(ClusterSettings clusterSettings) {
        if (this.enabled) {
            this.clusterService.addListener(this.taskStarter);
            this.clusterService.addListener(this.shutdownListener);
        }
        clusterSettings.addSettingsUpdateConsumer(ENABLED_SETTING, this::enable);
    }

    private void enable(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.clusterService.addListener(this.taskStarter);
            this.clusterService.addListener(this.shutdownListener);
        } else {
            this.clusterService.removeListener(this.taskStarter);
            this.clusterService.removeListener(this.shutdownListener);
            this.abortTaskIfApplicable("disabling health node via '" + ENABLED_SETTING.getKey() + "'");
        }
    }

    @Override
    protected void nodeOperation(AllocatedPersistentTask task, HealthNodeTaskParams params, PersistentTaskState state) {
        HealthNode healthNode = (HealthNode)task;
        this.currentTask.set(healthNode);
        DiscoveryNode node = this.clusterService.localNode();
        logger.info("Node [{{}}{{}}] is selected as the current health node.", (Object)node.getName(), (Object)node.getId());
    }

    protected HealthNode createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<HealthNodeTaskParams> taskInProgress, Map<String, String> headers) {
        return new HealthNode(id, type, action, this.getDescription(taskInProgress), parentTaskId, headers);
    }

    @Override
    public PersistentTasksCustomMetadata.Assignment getAssignment(HealthNodeTaskParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        DiscoveryNode discoveryNode = this.selectLeastLoadedNode(clusterState, candidateNodes, DiscoveryNode::canContainData);
        if (discoveryNode == null) {
            return NO_NODE_FOUND;
        }
        return new PersistentTasksCustomMetadata.Assignment(discoveryNode.getId(), "");
    }

    void startTask(ClusterChangedEvent event) {
        if (event.state().clusterRecovered() && this.featureService.clusterHasFeature(event.state(), HealthFeatures.SUPPORTS_HEALTH)) {
            boolean healthNodeTaskExists = HealthNode.findTask(event.state()) != null;
            boolean isElectedMaster = event.localNodeMaster();
            if (isElectedMaster || healthNodeTaskExists) {
                this.clusterService.removeListener(this.taskStarter);
            }
            if (isElectedMaster && !healthNodeTaskExists) {
                this.persistentTasksService.sendStartRequest("health-node", "health-node", new HealthNodeTaskParams(), ActionListener.wrap(r -> logger.debug("Created the health node task"), e -> {
                    Throwable t;
                    Throwable throwable = t = e instanceof RemoteTransportException ? e.getCause() : e;
                    if (!(t instanceof ResourceAlreadyExistsException)) {
                        logger.error("Failed to create the health node task", (Throwable)e);
                        if (this.enabled) {
                            this.clusterService.addListener(this.taskStarter);
                        }
                    }
                }));
            }
        }
    }

    void shuttingDown(ClusterChangedEvent event) {
        DiscoveryNode node = this.clusterService.localNode();
        if (HealthNodeTaskExecutor.isNodeShuttingDown(event, node.getId())) {
            this.abortTaskIfApplicable("node [{" + node.getName() + "}{" + node.getId() + "}] shutting down");
        }
    }

    void abortTaskIfApplicable(String reason) {
        HealthNode task = this.currentTask.get();
        if (task != null && !task.isCancelled()) {
            logger.info("Aborting health node task due to {}.", (Object)reason);
            task.markAsLocallyAborted(reason);
            this.currentTask.set(null);
        }
    }

    private static boolean isNodeShuttingDown(ClusterChangedEvent event, String nodeId) {
        return !event.previousState().metadata().nodeShutdowns().contains(nodeId) && event.state().metadata().nodeShutdowns().contains(nodeId);
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContentParsers() {
        return List.of(new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("health-node", new String[0]), HealthNodeTaskParams::fromXContent));
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "health-node", HealthNodeTaskParams::new));
    }
}

