/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.node.DataStreamLifecycleHealthInfo;
import org.elasticsearch.health.node.DiskHealthInfo;
import org.elasticsearch.health.node.HealthInfoCache;
import org.elasticsearch.health.node.action.HealthNodeRequest;
import org.elasticsearch.health.node.action.TransportHealthNodeAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class UpdateHealthInfoCacheAction
extends ActionType<AcknowledgedResponse> {
    public static final UpdateHealthInfoCacheAction INSTANCE = new UpdateHealthInfoCacheAction();
    public static final String NAME = "cluster:monitor/update/health/info";

    private UpdateHealthInfoCacheAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class TransportAction
    extends TransportHealthNodeAction<Request, AcknowledgedResponse> {
        private final HealthInfoCache nodeHealthOverview;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, HealthInfoCache nodeHealthOverview) {
            super(UpdateHealthInfoCacheAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, AcknowledgedResponse::readFrom, threadPool.executor("management"));
            this.nodeHealthOverview = nodeHealthOverview;
        }

        @Override
        protected void healthOperation(Task task, Request request, ClusterState clusterState, ActionListener<AcknowledgedResponse> listener) {
            this.nodeHealthOverview.updateNodeHealth(request.getNodeId(), request.getDiskHealthInfo(), request.getDslHealthInfo());
            listener.onResponse(AcknowledgedResponse.of(true));
        }
    }

    public static class Request
    extends HealthNodeRequest {
        private final String nodeId;
        @Nullable
        private final DiskHealthInfo diskHealthInfo;
        @Nullable
        private final DataStreamLifecycleHealthInfo dslHealthInfo;

        public Request(String nodeId, DiskHealthInfo diskHealthInfo) {
            this.nodeId = nodeId;
            this.diskHealthInfo = diskHealthInfo;
            this.dslHealthInfo = null;
        }

        public Request(String nodeId, DataStreamLifecycleHealthInfo dslHealthInfo) {
            this.nodeId = nodeId;
            this.diskHealthInfo = null;
            this.dslHealthInfo = dslHealthInfo;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.nodeId = in.readString();
            if (in.getTransportVersion().onOrAfter(TransportVersions.HEALTH_INFO_ENRICHED_WITH_DSL_STATUS)) {
                this.diskHealthInfo = in.readOptionalWriteable(DiskHealthInfo::new);
                this.dslHealthInfo = in.readOptionalWriteable(DataStreamLifecycleHealthInfo::new);
            } else {
                this.diskHealthInfo = new DiskHealthInfo(in);
                this.dslHealthInfo = null;
            }
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public DiskHealthInfo getDiskHealthInfo() {
            return this.diskHealthInfo;
        }

        public DataStreamLifecycleHealthInfo getDslHealthInfo() {
            return this.dslHealthInfo;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
            if (out.getTransportVersion().onOrAfter(TransportVersions.HEALTH_INFO_ENRICHED_WITH_DSL_STATUS)) {
                out.writeOptionalWriteable(this.diskHealthInfo);
                out.writeOptionalWriteable(this.dslHealthInfo);
            } else {
                this.diskHealthInfo.writeTo(out);
            }
        }

        @Override
        public String getDescription() {
            return "Update health info cache for node [" + this.nodeId + "] with disk health info [" + this.diskHealthInfo + "] and DSL health info [" + this.dslHealthInfo + "].";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.nodeId, request.nodeId) && Objects.equals(this.diskHealthInfo, request.diskHealthInfo) && Objects.equals(this.dslHealthInfo, request.dslHealthInfo);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.diskHealthInfo, this.dslHealthInfo);
        }
    }
}

