/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.reservedstate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComponentTemplateAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class ReservedComposableIndexTemplateAction
implements ReservedClusterStateHandler<ComponentsAndComposables> {
    public static final String NAME = "index_templates";
    public static final String COMPONENTS = "component_templates";
    private static final String COMPONENT_PREFIX = "component_template:";
    public static final String COMPOSABLES = "composable_index_templates";
    public static final String COMPOSABLE_PREFIX = "composable_index_template:";
    private final MetadataIndexTemplateService indexTemplateService;
    private final IndexScopedSettings indexScopedSettings;

    public ReservedComposableIndexTemplateAction(MetadataIndexTemplateService indexTemplateService, IndexScopedSettings indexScopedSettings) {
        this.indexTemplateService = indexTemplateService;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    public String name() {
        return NAME;
    }

    public static String reservedComponentName(String name) {
        return COMPONENT_PREFIX + name;
    }

    public static String componentNameFromReservedName(String name) {
        assert (name.startsWith(COMPONENT_PREFIX));
        return name.substring(COMPONENT_PREFIX.length());
    }

    public static String reservedComposableIndexName(String name) {
        return COMPOSABLE_PREFIX + name;
    }

    public static String composableIndexNameFromReservedName(String name) {
        assert (name.startsWith(COMPOSABLE_PREFIX));
        return name.substring(COMPOSABLE_PREFIX.length());
    }

    private ComponentsAndComposables prepare(ComponentsAndComposables componentsAndComposables) {
        for (PutComponentTemplateAction.Request request : componentsAndComposables.componentTemplates) {
            this.validate(request);
        }
        for (PutComposableIndexTemplateAction.Request request : componentsAndComposables.composableTemplates) {
            this.validate(request);
        }
        return componentsAndComposables;
    }

    @Override
    public TransformState transform(Object source, TransformState prevState) throws Exception {
        ComponentsAndComposables requests = this.prepare((ComponentsAndComposables)source);
        ClusterState state = prevState.state();
        List<PutComponentTemplateAction.Request> components = requests.componentTemplates;
        List<PutComposableIndexTemplateAction.Request> composables = requests.composableTemplates;
        for (PutComponentTemplateAction.Request request : components) {
            ComponentTemplate template = TransportPutComponentTemplateAction.normalizeComponentTemplate(request.componentTemplate(), this.indexScopedSettings);
            state = this.indexTemplateService.addComponentTemplate(state, false, request.name(), template);
        }
        for (PutComposableIndexTemplateAction.Request request : composables) {
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), request.name(), request.indexTemplate());
            state = this.indexTemplateService.addIndexTemplateV2(state, false, request.name(), request.indexTemplate(), false);
        }
        Set composableEntities = composables.stream().map(r -> ReservedComposableIndexTemplateAction.reservedComposableIndexName(r.name())).collect(Collectors.toSet());
        Set set = prevState.keys().stream().filter(k -> k.startsWith(COMPOSABLE_PREFIX) && !composableEntities.contains(k)).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            String[] composableNames = (String[])set.stream().map(c -> ReservedComposableIndexTemplateAction.composableIndexNameFromReservedName(c)).toArray(String[]::new);
            state = MetadataIndexTemplateService.innerRemoveIndexTemplateV2(state, composableNames);
        }
        for (PutComposableIndexTemplateAction.Request request : composables) {
            MetadataIndexTemplateService.v2TemplateOverlaps(state, request.name(), request.indexTemplate(), true);
        }
        Set componentEntities = components.stream().map(r -> ReservedComposableIndexTemplateAction.reservedComponentName(r.name())).collect(Collectors.toSet());
        Set componentsToDelete = prevState.keys().stream().filter(k -> k.startsWith(COMPONENT_PREFIX)).collect(Collectors.toSet());
        componentsToDelete.removeAll(componentEntities);
        if (!componentsToDelete.isEmpty()) {
            String[] componentNames = (String[])componentsToDelete.stream().map(c -> ReservedComposableIndexTemplateAction.componentNameFromReservedName(c)).toArray(String[]::new);
            state = MetadataIndexTemplateService.innerRemoveComponentTemplate(state, componentNames);
        }
        return new TransformState(state, Sets.union(componentEntities, composableEntities));
    }

    @Override
    public ComponentsAndComposables fromXContent(XContentParser parser) throws IOException {
        Map composables;
        ArrayList<PutComponentTemplateAction.Request> componentTemplates = new ArrayList<PutComponentTemplateAction.Request>();
        ArrayList<PutComposableIndexTemplateAction.Request> composableTemplates = new ArrayList<PutComposableIndexTemplateAction.Request>();
        Map source = parser.map();
        Map components = (Map)source.get(COMPONENTS);
        if (components != null) {
            for (Map.Entry entry : components.entrySet()) {
                Map content = (Map)entry.getValue();
                try (XContentParser componentParser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, content);){
                    PutComponentTemplateAction.Request componentTemplate = new PutComponentTemplateAction.Request((String)entry.getKey());
                    componentTemplate.componentTemplate(ComponentTemplate.parse(componentParser));
                    componentTemplates.add(componentTemplate);
                }
            }
        }
        if ((composables = (Map)source.get(COMPOSABLES)) != null) {
            for (Map.Entry entry : composables.entrySet()) {
                Map content = (Map)entry.getValue();
                try (XContentParser componentParser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, content);){
                    PutComposableIndexTemplateAction.Request composableTemplate = new PutComposableIndexTemplateAction.Request((String)entry.getKey());
                    composableTemplate.indexTemplate(ComposableIndexTemplate.parse(componentParser));
                    composableTemplates.add(composableTemplate);
                }
            }
        }
        return new ComponentsAndComposables(componentTemplates, composableTemplates);
    }

    record ComponentsAndComposables(List<PutComponentTemplateAction.Request> componentTemplates, List<PutComposableIndexTemplateAction.Request> composableTemplates) {
    }
}

