/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.close;

import java.util.Arrays;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.close.CloseIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.Index;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCloseIndexAction
extends TransportMasterNodeAction<CloseIndexRequest, CloseIndexResponse> {
    private static final Logger logger = LogManager.getLogger(TransportCloseIndexAction.class);
    private final MetadataIndexStateService indexStateService;
    private final DestructiveOperations destructiveOperations;
    private volatile boolean closeIndexEnabled;
    public static final Setting<Boolean> CLUSTER_INDICES_CLOSE_ENABLE_SETTING = Setting.boolSetting("cluster.indices.close.enable", true, Setting.Property.Dynamic, Setting.Property.NodeScope);

    @Inject
    public TransportCloseIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexStateService indexStateService, ClusterSettings clusterSettings, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super("indices:admin/close", transportService, clusterService, threadPool, actionFilters, CloseIndexRequest::new, indexNameExpressionResolver, CloseIndexResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexStateService = indexStateService;
        this.destructiveOperations = destructiveOperations;
        this.closeIndexEnabled = CLUSTER_INDICES_CLOSE_ENABLE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_INDICES_CLOSE_ENABLE_SETTING, this::setCloseIndexEnabled);
    }

    private void setCloseIndexEnabled(boolean closeIndexEnabled) {
        this.closeIndexEnabled = closeIndexEnabled;
    }

    @Override
    protected void doExecute(Task task, CloseIndexRequest request, ActionListener<CloseIndexResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        if (!this.closeIndexEnabled) {
            throw new IllegalStateException("closing indices is disabled - set [" + CLUSTER_INDICES_CLOSE_ENABLE_SETTING.getKey() + ": true] to enable it. NOTE: closed indices still consume a significant amount of diskspace");
        }
        super.doExecute(task, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(CloseIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(Task task, CloseIndexRequest request, ClusterState state, ActionListener<CloseIndexResponse> listener) throws Exception {
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse(new CloseIndexResponse(true, false, Collections.emptyList()));
            return;
        }
        CloseIndexClusterStateUpdateRequest closeRequest = (CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)new CloseIndexClusterStateUpdateRequest(task.getId()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).waitForActiveShards(request.waitForActiveShards()).indices(concreteIndices);
        this.indexStateService.closeIndices(closeRequest, listener.delegateResponse((delegatedListener, t) -> {
            logger.debug(() -> "failed to close indices [" + Arrays.toString(concreteIndices) + "]", (Throwable)t);
            delegatedListener.onFailure((Exception)t);
        }));
    }
}

