/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.Writeable;

public class ActionType<Response extends ActionResponse> {
    private final String name;
    private final Writeable.Reader<Response> responseReader;

    public static <T extends ActionResponse> ActionType<T> localOnly(String name) {
        return new ActionType(name, Writeable.Reader.localOnly());
    }

    public ActionType(String name, Writeable.Reader<Response> responseReader) {
        this.name = name;
        this.responseReader = responseReader;
    }

    public String name() {
        return this.name;
    }

    public Writeable.Reader<Response> getResponseReader() {
        return this.responseReader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ActionType)) return false;
        ActionType actionType = (ActionType)o;
        if (!this.name.equals(actionType.name)) return false;
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

