/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;

public abstract class ActionRunnable<Response>
extends AbstractRunnable {
    protected final ActionListener<Response> listener;

    public static <T> ActionRunnable<T> run(ActionListener<T> listener, final CheckedRunnable<Exception> runnable) {
        return new ActionRunnable<T>(listener){

            @Override
            protected void doRun() throws Exception {
                runnable.run();
                this.listener.onResponse(null);
            }
        };
    }

    public static <T> ActionRunnable<T> supply(ActionListener<T> listener, final CheckedSupplier<T, Exception> supplier) {
        return ActionRunnable.wrap(listener, new CheckedConsumer<ActionListener<T>, Exception>(){

            public void accept(ActionListener<T> l) throws Exception {
                l.onResponse(supplier.get());
            }

            public String toString() {
                return supplier.toString();
            }
        });
    }

    public static <T extends RefCounted> ActionRunnable<T> supplyAndDecRef(ActionListener<T> listener, final CheckedSupplier<T, Exception> supplier) {
        return ActionRunnable.wrap(listener, new CheckedConsumer<ActionListener<T>, Exception>(){

            public void accept(ActionListener<T> l) throws Exception {
                ActionListener.respondAndRelease(l, (RefCounted)supplier.get());
            }

            public String toString() {
                return supplier.toString();
            }
        });
    }

    public static <T> ActionRunnable<T> wrap(ActionListener<T> listener, final CheckedConsumer<ActionListener<T>, Exception> consumer) {
        return new ActionRunnable<T>(listener){

            @Override
            protected void doRun() throws Exception {
                consumer.accept((Object)this.listener);
            }

            @Override
            public String toString() {
                return "ActionRunnable#wrap[" + consumer + "]";
            }
        };
    }

    public static <T> ActionRunnable<T> wrapReleasing(ActionListener<T> listener, final Releasable releasable, final CheckedConsumer<ActionListener<T>, Exception> consumer) {
        return new ActionRunnable<T>(listener){

            @Override
            protected void doRun() {
                try (Releasable releasable2 = releasable;){
                    ActionListener.run(this.listener, consumer);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try (Releasable releasable2 = releasable;){
                    super.onFailure(e);
                }
            }

            @Override
            public String toString() {
                return "ActionRunnable#wrapReleasing[" + consumer + "]";
            }
        };
    }

    public ActionRunnable(ActionListener<Response> listener) {
        this.listener = listener;
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    public String toString() {
        return this.getClass().getName() + "/" + this.listener;
    }
}

