/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ParsedTopHits
extends ParsedAggregation
implements TopHits {
    private SearchHits searchHits;
    private static final ObjectParser<ParsedTopHits, Void> PARSER = new ObjectParser(ParsedTopHits.class.getSimpleName(), true, ParsedTopHits::new);

    @Override
    public String getType() {
        return "top_hits";
    }

    @Override
    public SearchHits getHits() {
        return this.searchHits;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return ChunkedToXContent.wrapAsToXContent(this.searchHits).toXContent(builder, params);
    }

    public static ParsedTopHits fromXContent(XContentParser parser, String name) throws IOException {
        ParsedTopHits aggregation = (ParsedTopHits)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedTopHits.declareAggregationFields(PARSER);
        PARSER.declareObject((topHit, searchHits) -> {
            topHit.searchHits = searchHits;
        }, (parser, context) -> SearchHits.fromXContent(parser), new ParseField("hits", new String[0]));
    }
}

