/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.search.aggregations.metrics.ParsedPercentiles;
import org.elasticsearch.search.aggregations.metrics.Percentiles;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.XContentParser;

public class ParsedTDigestPercentiles
extends ParsedPercentiles
implements Percentiles {
    private static final ObjectParser<ParsedTDigestPercentiles, Void> PARSER = new ObjectParser(ParsedTDigestPercentiles.class.getSimpleName(), true, ParsedTDigestPercentiles::new);

    @Override
    public String getType() {
        return "tdigest_percentiles";
    }

    @Override
    public double percentile(double percent) {
        return this.getPercentile(percent);
    }

    @Override
    public String percentileAsString(double percent) {
        return this.getPercentileAsString(percent);
    }

    @Override
    public double value(String name) {
        return this.percentile(Double.parseDouble(name));
    }

    @Override
    public Iterable<String> valueNames() {
        return this.percentiles.keySet().stream().map(Object::toString).toList();
    }

    public static ParsedTDigestPercentiles fromXContent(XContentParser parser, String name) throws IOException {
        ParsedTDigestPercentiles aggregation = (ParsedTDigestPercentiles)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedPercentiles.declarePercentilesFields(PARSER);
    }
}

