/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Aggregations
implements Iterable<Aggregation>,
ToXContentFragment {
    public static final String AGGREGATIONS_FIELD = "aggregations";
    protected final List<? extends Aggregation> aggregations;
    private Map<String, Aggregation> aggregationsAsMap;

    public Aggregations(List<? extends Aggregation> aggregations) {
        this.aggregations = aggregations;
        if (aggregations.isEmpty()) {
            this.aggregationsAsMap = Collections.emptyMap();
        }
    }

    @Override
    public final Iterator<Aggregation> iterator() {
        return Iterators.map(this.aggregations.iterator(), p -> p);
    }

    public final List<Aggregation> asList() {
        return Collections.unmodifiableList(this.aggregations);
    }

    public final Map<String, Aggregation> asMap() {
        return this.getAsMap();
    }

    public final Map<String, Aggregation> getAsMap() {
        if (this.aggregationsAsMap == null) {
            Map<String, Aggregation> newAggregationsAsMap = Maps.newMapWithExpectedSize(this.aggregations.size());
            for (Aggregation aggregation : this.aggregations) {
                newAggregationsAsMap.put(aggregation.getName(), aggregation);
            }
            this.aggregationsAsMap = Collections.unmodifiableMap(newAggregationsAsMap);
        }
        return this.aggregationsAsMap;
    }

    public final <A extends Aggregation> A get(String name) {
        return (A)this.asMap().get(name);
    }

    public final boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.aggregations.equals(((Aggregations)obj).aggregations);
    }

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.aggregations);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.aggregations.isEmpty()) {
            return builder;
        }
        builder.startObject(AGGREGATIONS_FIELD);
        this.toXContentInternal(builder, params);
        return builder.endObject();
    }

    public XContentBuilder toXContentInternal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Aggregation aggregation : this.aggregations) {
            aggregation.toXContent(builder, params);
        }
        return builder;
    }

    public static Aggregations fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.START_OBJECT) continue;
            SetOnce typedAgg = new SetOnce();
            String currentField = parser.currentName();
            XContentParserUtils.parseTypedKeysObject(parser, "#", Aggregation.class, arg_0 -> ((SetOnce)typedAgg).set(arg_0));
            if (typedAgg.get() != null) {
                aggregations.add((Aggregation)typedAgg.get());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Could not parse aggregation keyed as [%s]", currentField), new Object[0]);
        }
        return new Aggregations(aggregations);
    }
}

