/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public class ExtensionLoader {
    public static <T> T loadSingleton(ServiceLoader<T> loader, Supplier<T> fallback) {
        List<ServiceLoader.Provider<T>> extensions = loader.stream().toList();
        if (extensions.size() > 1) {
            throw new IllegalStateException(String.format(Locale.ROOT, "More than one extension found for %s", loader));
        }
        if (extensions.isEmpty()) {
            return fallback.get();
        }
        return extensions.get(0).get();
    }
}

