/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.util.Objects;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;

public class Model {
    private final ModelConfigurations configurations;
    private final ModelSecrets secrets;

    public static String documentId(String modelId) {
        return "model_" + modelId;
    }

    public Model(ModelConfigurations configurations, ModelSecrets secrets) {
        this.configurations = Objects.requireNonNull(configurations);
        this.secrets = Objects.requireNonNull(secrets);
    }

    public Model(ModelConfigurations configurations) {
        this(configurations, new ModelSecrets());
    }

    public String getModelId() {
        return this.configurations.getModelId();
    }

    public TaskType getTaskType() {
        return this.configurations.getTaskType();
    }

    public ModelConfigurations getConfigurations() {
        return this.configurations;
    }

    public ModelSecrets getSecrets() {
        return this.secrets;
    }

    public ServiceSettings getServiceSettings() {
        return this.configurations.getServiceSettings();
    }

    public TaskSettings getTaskSettings() {
        return this.configurations.getTaskSettings();
    }

    public SecretSettings getSecretSettings() {
        return this.secrets.getSecretSettings();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model model = (Model)o;
        return Objects.equals(this.configurations, model.configurations) && Objects.equals(this.secrets, model.secrets);
    }

    public int hashCode() {
        return Objects.hash(this.configurations, this.secrets);
    }
}

