/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AsyncIOProcessor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;

public abstract class MultiChunkTransfer<Source, Request extends ChunkRequest>
implements Closeable {
    private Status status = Status.PROCESSING;
    private final Logger logger;
    private final ActionListener<Void> listener;
    private final LocalCheckpointTracker requestSeqIdTracker = new LocalCheckpointTracker(-1L, -1L);
    private final AsyncIOProcessor<FileChunkResponseItem<Source>> processor;
    private final int maxConcurrentChunks;
    private Source currentSource = null;
    private final Iterator<Source> remainingSources;
    private Tuple<Source, Request> readAheadRequest = null;

    protected MultiChunkTransfer(Logger logger, ThreadContext threadContext, ActionListener<Void> listener, int maxConcurrentChunks, List<Source> sources) {
        this.logger = logger;
        this.maxConcurrentChunks = maxConcurrentChunks;
        this.listener = listener;
        this.processor = new AsyncIOProcessor<FileChunkResponseItem<Source>>(logger, maxConcurrentChunks, threadContext){

            @Override
            protected void write(List<Tuple<FileChunkResponseItem<Source>, Consumer<Exception>>> items) {
                MultiChunkTransfer.this.handleItems(items);
            }
        };
        this.remainingSources = sources.iterator();
    }

    public final void start() {
        this.addItem(-2L, null, null);
    }

    private void addItem(long requestSeqId, Source resource, Exception failure) {
        this.processor.put(new FileChunkResponseItem<Source>(requestSeqId, resource, failure), e -> {
            assert (e == null) : e;
        });
    }

    private void handleItems(List<Tuple<FileChunkResponseItem<Source>, Consumer<Exception>>> items) {
        if (this.status != Status.PROCESSING) {
            assert (this.status == Status.FAILED) : "must not receive any response after the transfer was completed";
            items.stream().filter(item -> ((FileChunkResponseItem)item.v1()).failure != null).forEach(item -> this.logger.debug(() -> Strings.format((String)"failed to transfer a chunk request %s", (Object[])new Object[]{((FileChunkResponseItem)item.v1()).source}), (Throwable)((FileChunkResponseItem)item.v1()).failure));
            return;
        }
        try {
            for (Tuple<FileChunkResponseItem<Source>, Consumer<Exception>> item2 : items) {
                FileChunkResponseItem resp = (FileChunkResponseItem)item2.v1();
                if (resp.requestSeqId == -2L) continue;
                this.requestSeqIdTracker.markSeqNoAsProcessed(resp.requestSeqId);
                if (resp.failure == null) continue;
                this.handleError(resp.source, resp.failure);
                throw resp.failure;
            }
            while (this.requestSeqIdTracker.getMaxSeqNo() - this.requestSeqIdTracker.getProcessedCheckpoint() < (long)this.maxConcurrentChunks) {
                Tuple<Source, Request> request = this.readAheadRequest != null ? this.readAheadRequest : this.getNextRequest();
                this.readAheadRequest = null;
                if (request == null) {
                    assert (this.currentSource == null && !this.remainingSources.hasNext());
                    if (this.requestSeqIdTracker.getMaxSeqNo() == this.requestSeqIdTracker.getProcessedCheckpoint()) {
                        this.onCompleted(null);
                    }
                    return;
                }
                long requestSeqId = this.requestSeqIdTracker.generateSeqNo();
                this.executeChunkRequest((ChunkRequest)request.v2(), ActionListener.wrap(r -> this.addItem(requestSeqId, request.v1(), null), e -> this.addItem(requestSeqId, (Source)request.v1(), (Exception)e)));
            }
            if (this.readAheadRequest == null) {
                this.readAheadRequest = this.getNextRequest();
            }
        }
        catch (Exception e2) {
            this.onCompleted(e2);
        }
    }

    protected boolean assertOnSuccess() {
        return true;
    }

    private void onCompleted(Exception failure) {
        if (Assertions.ENABLED && this.status != Status.PROCESSING) {
            throw new AssertionError("invalid status: expected [" + Status.PROCESSING + "] actual [" + this.status + "]", failure);
        }
        Status status = this.status = failure == null ? Status.SUCCESS : Status.FAILED;
        assert (this.status != Status.SUCCESS || this.assertOnSuccess());
        try {
            IOUtils.close((Exception)failure, (Closeable[])new Closeable[]{this});
        }
        catch (Exception e) {
            this.listener.onFailure(e);
            return;
        }
        this.listener.onResponse(null);
    }

    private Tuple<Source, Request> getNextRequest() throws Exception {
        try {
            Source md;
            Request request;
            if (this.currentSource == null) {
                if (this.remainingSources.hasNext()) {
                    this.currentSource = this.remainingSources.next();
                    this.onNewResource(this.currentSource);
                } else {
                    return null;
                }
            }
            if ((request = this.nextChunkRequest(md = this.currentSource)).lastChunk()) {
                this.currentSource = null;
            }
            return Tuple.tuple(md, request);
        }
        catch (Exception e) {
            this.handleError(this.currentSource, e);
            throw e;
        }
    }

    protected void onNewResource(Source resource) throws IOException {
    }

    protected abstract Request nextChunkRequest(Source var1) throws IOException;

    protected abstract void executeChunkRequest(Request var1, ActionListener<Void> var2);

    protected abstract void handleError(Source var1, Exception var2) throws Exception;

    private static enum Status {
        PROCESSING,
        SUCCESS,
        FAILED;

    }

    private record FileChunkResponseItem<Source>(long requestSeqId, Source source, Exception failure) {
    }

    public static interface ChunkRequest {
        public boolean lastChunk();
    }
}

