/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.IndexSettings;

public interface DocumentDimensions {
    public static DocumentDimensions fromIndexSettings(IndexSettings indexSettings) {
        return indexSettings.getMode().buildDocumentDimensions(indexSettings);
    }

    public void addString(String var1, BytesRef var2);

    default public void addString(String fieldName, String value) {
        this.addString(fieldName, new BytesRef((CharSequence)value));
    }

    public void addIp(String var1, InetAddress var2);

    public void addLong(String var1, long var2);

    public void addUnsignedLong(String var1, long var2);

    public static class OnlySingleValueAllowed
    implements DocumentDimensions {
        private final Set<String> names = new HashSet<String>();

        @Override
        public void addString(String fieldName, BytesRef value) {
            this.add(fieldName);
        }

        @Override
        public void addString(String fieldName, String value) {
            this.add(fieldName);
        }

        @Override
        public void addIp(String fieldName, InetAddress value) {
            this.add(fieldName);
        }

        @Override
        public void addLong(String fieldName, long value) {
            this.add(fieldName);
        }

        @Override
        public void addUnsignedLong(String fieldName, long value) {
            this.add(fieldName);
        }

        private void add(String fieldName) {
            boolean isNew = this.names.add(fieldName);
            if (!isNew) {
                throw new IllegalArgumentException("Dimension field [" + fieldName + "] cannot be a multi-valued field.");
            }
        }
    }
}

