/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public abstract class BlockSourceReader
implements BlockLoader.RowStrideReader {
    private final ValueFetcher fetcher;
    private final List<Object> ignoredValues = new ArrayList<Object>();

    BlockSourceReader(ValueFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public final void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
        List<Object> values = this.fetcher.fetchValues(storedFields.source(), docId, this.ignoredValues);
        this.ignoredValues.clear();
        if (values == null || values.isEmpty()) {
            builder.appendNull();
            return;
        }
        if (values.size() == 1) {
            this.append(builder, values.get(0));
            return;
        }
        builder.beginPositionEntry();
        for (Object v : values) {
            this.append(builder, v);
        }
        builder.endPositionEntry();
    }

    protected abstract void append(BlockLoader.Builder var1, Object var2);

    @Override
    public boolean canReuse(int startingDocID) {
        return true;
    }

    static BytesRef toBytesRef(BytesRef scratch, String v) {
        int len = UnicodeUtil.maxUTF8Length((int)v.length());
        if (scratch.bytes.length < len) {
            scratch.bytes = new byte[len];
        }
        scratch.length = UnicodeUtil.UTF16toUTF8((CharSequence)v, (int)0, (int)v.length(), (byte[])scratch.bytes);
        return scratch;
    }

    private static class Longs
    extends BlockSourceReader {
        Longs(ValueFetcher fetcher) {
            super(fetcher);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.LongBuilder)builder).appendLong(((Number)v).longValue());
        }

        public String toString() {
            return "BlockSourceReader.Longs";
        }
    }

    public static class LongsBlockLoader
    extends SourceBlockLoader {
        private final ValueFetcher fetcher;

        public LongsBlockLoader(ValueFetcher fetcher) {
            this.fetcher = fetcher;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.longs(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) {
            return new Longs(this.fetcher);
        }
    }

    private static class Ints
    extends BlockSourceReader {
        Ints(ValueFetcher fetcher) {
            super(fetcher);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.IntBuilder)builder).appendInt(((Number)v).intValue());
        }

        public String toString() {
            return "BlockSourceReader.Ints";
        }
    }

    public static class IntsBlockLoader
    extends SourceBlockLoader {
        private final ValueFetcher fetcher;

        public IntsBlockLoader(ValueFetcher fetcher) {
            this.fetcher = fetcher;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.ints(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) {
            return new Ints(this.fetcher);
        }
    }

    private static class Doubles
    extends BlockSourceReader {
        Doubles(ValueFetcher fetcher) {
            super(fetcher);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.DoubleBuilder)builder).appendDouble(((Number)v).doubleValue());
        }

        public String toString() {
            return "BlockSourceReader.Doubles";
        }
    }

    public static class DoublesBlockLoader
    extends SourceBlockLoader {
        private final ValueFetcher fetcher;

        public DoublesBlockLoader(ValueFetcher fetcher) {
            this.fetcher = fetcher;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.doubles(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) {
            return new Doubles(this.fetcher);
        }
    }

    private static class BytesRefs
    extends BlockSourceReader {
        BytesRef scratch = new BytesRef();

        BytesRefs(ValueFetcher fetcher) {
            super(fetcher);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(BytesRefs.toBytesRef(this.scratch, (String)v));
        }

        public String toString() {
            return "BlockSourceReader.Bytes";
        }
    }

    public static class BytesRefsBlockLoader
    extends SourceBlockLoader {
        private final ValueFetcher fetcher;

        public BytesRefsBlockLoader(ValueFetcher fetcher) {
            this.fetcher = fetcher;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) {
            return new BytesRefs(this.fetcher);
        }
    }

    private static class Booleans
    extends BlockSourceReader {
        Booleans(ValueFetcher fetcher) {
            super(fetcher);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.BooleanBuilder)builder).appendBoolean((Boolean)v);
        }

        public String toString() {
            return "BlockSourceReader.Booleans";
        }
    }

    public static class BooleansBlockLoader
    extends SourceBlockLoader {
        private final ValueFetcher fetcher;

        public BooleansBlockLoader(ValueFetcher fetcher) {
            this.fetcher = fetcher;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.booleans(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) {
            return new Booleans(this.fetcher);
        }
    }

    private static abstract class SourceBlockLoader
    implements BlockLoader {
        private SourceBlockLoader() {
        }

        @Override
        public final BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            return null;
        }

        @Override
        public final StoredFieldsSpec rowStrideStoredFieldSpec() {
            return StoredFieldsSpec.NEEDS_SOURCE;
        }

        @Override
        public final boolean supportsOrdinals() {
            return false;
        }

        @Override
        public final SortedSetDocValues ordinals(LeafReaderContext context) {
            throw new UnsupportedOperationException();
        }
    }
}

